/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class InjectedLanguageUtil {
    public static final Key<IElementType> INJECTED_FRAGMENT_TYPE = Key.create((String)"INJECTED_FRAGMENT_TYPE");
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = InjectedLanguageManager.FRANKENSTEIN_INJECTION;
    private static final Key<List<TokenInfo>> HIGHLIGHT_TOKENS = Key.create((String)"HIGHLIGHT_TOKENS");
    private static final Key<Getter<InjectionResult>> INJECTED_PSI = Key.create((String)"INJECTED_PSI");
    private static final Key<InjectionResult> INJECTION_HOLDER_BACK_REFERENCE = Key.create((String)"INJECTION_HOLDER_BACK_REFERENCE");
    private static final Key<List<DocumentWindow>> INJECTED_DOCS_KEY = Key.create((String)"INJECTED_DOCS_KEY");

    @NotNull
    static PsiElement loadTree(@NotNull PsiElement host, @NotNull PsiFile containingFile) {
        PsiElement context;
        if (containingFile instanceof DummyHolder && (context = containingFile.getContext()) != null) {
            PsiFile topFile = context.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context.getTextRange().getStartOffset());
            PsiElement inLoadedTree = PsiTreeUtil.findElementOfClassAtRange((PsiFile)topFile, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        return host;
    }

    public static List<TokenInfo> getHighlightTokens(@NotNull PsiFile file2) {
        return (List)file2.getUserData(HIGHLIGHT_TOKENS);
    }

    static void setHighlightTokens(@NotNull PsiFile file2, @NotNull List<TokenInfo> tokens) {
        file2.putUserData(HIGHLIGHT_TOKENS, tokens);
    }

    public static Place getShreds(@NotNull PsiFile injectedFile) {
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        return InjectedLanguageUtil.getShreds(viewProvider);
    }

    public static Place getShreds(@NotNull FileViewProvider viewProvider) {
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return InjectedLanguageUtil.getShreds(myFileViewProvider.getDocument());
    }

    @NotNull
    private static Place getShreds(@NotNull DocumentWindow document) {
        return ((DocumentWindowImpl)document).getShreds();
    }

    public static void enumerate(@NotNull DocumentWindow documentWindow, @NotNull PsiFile hostPsiFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement element2;
        Segment[] ranges = documentWindow.getHostRanges();
        Segment rangeMarker = ranges.length > 0 ? ranges[0] : null;
        PsiElement psiElement = element2 = rangeMarker == null ? null : hostPsiFile.findElementAt(rangeMarker.getStartOffset());
        if (element2 != null) {
            InjectedLanguageUtil.enumerate(element2, hostPsiFile, true, visitor);
        }
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiFile containingFile = host.getContainingFile();
        PsiUtilCore.ensureValid((PsiElement)containingFile);
        return InjectedLanguageUtil.enumerate(host, containingFile, true, visitor);
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiDocumentManager documentManager;
        Document document;
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            if (context == null) {
                return false;
            }
            PsiFile file2 = context.getContainingFile();
            if (file2 == null || !file2.isPhysical() && file2.getOriginalFile() == file2) {
                return false;
            }
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return false;
        }
        PsiElement inTree = InjectedLanguageUtil.loadTree(host, containingFile);
        if (inTree != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)containingFile.getProject())).getDocument(containingFile)) == null || documentManager.isCommitted(document)) {
            InjectedLanguageUtil.probeElementsUp(host, containingFile, probeUp, visitor);
        }
        return true;
    }

    @Contract(value="null,_->null;!null,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2, offset);
    }

    static boolean mightHaveInjectedFragmentAtCaret(@NotNull Project project, @NotNull Document hostDocument, int hostOffset) {
        PsiFile hostPsiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(hostDocument);
        if (hostPsiFile == null || !hostPsiFile.isValid()) {
            return false;
        }
        List documents = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostPsiFile, TextRange.create((int)hostOffset, (int)hostOffset));
        for (DocumentWindow document : documents) {
            if (!document.isValid() || document.getHostRange(hostOffset) == null) continue;
            return true;
        }
        return false;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable Caret caret, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow || caret == null) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, caret, injectedFile);
    }

    public static Caret getCaretForInjectedLanguageNoCommit(@Nullable Caret caret, @Nullable PsiFile file2) {
        if (caret == null || file2 == null || caret instanceof InjectedCaret) {
            return caret;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(caret.getEditor(), injectedFile);
        if (!(injectedEditor instanceof EditorWindow)) {
            return caret;
        }
        for (Caret injectedCaret : injectedEditor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)injectedCaret).getDelegate() != caret) continue;
            return injectedCaret;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiFileBase> T findInjectedFile(@NotNull PsiElement expression, @NotNull Class<T> classToFind) {
        List files2 = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression);
        if (files2 == null) {
            return null;
        }
        for (Pair fileInfo : files2) {
            PsiElement injectedFile = (PsiElement)fileInfo.first;
            if (!classToFind.isAssignableFrom(injectedFile.getClass())) continue;
            return (T)((PsiFileBase)injectedFile);
        }
        return null;
    }

    @Contract(value="null,_,_->null;!null,_,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2, int offset) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable Caret hostCaret, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (injectedFile == null || hostEditor instanceof EditorWindow || hostEditor.isDisposed()) {
            return hostEditor;
        }
        Project project = hostEditor.getProject();
        if (project == null) {
            project = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance((Project)project).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            return hostEditor;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        if (hostCaret != null && hostCaret.hasSelection() && (selstart = hostCaret.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, hostCaret.getSelectionEnd()))) {
            return hostEditor;
        }
        if (!documentWindow.isValid()) {
            return hostEditor;
        }
        return EditorWindowImpl.create(documentWindow, (EditorImpl)hostEditor, injectedFile);
    }

    @Nullable
    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset) {
        PsiElement injected = InjectedLanguageManager.getInstance((Project)host.getProject()).findInjectedElementAt(host, offset);
        return injected == null ? null : injected.getContainingFile();
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file2, int offset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        Trinity<PsiElement, PsiElement, Language> result2 = null;
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            result2 = InjectedLanguageUtil.tryOffset(file2, offset, documentManager);
            PsiElement injected = (PsiElement)result2.first;
            if (injected != null) {
                return injected;
            }
        }
        Language baseLanguage = viewProvider.getBaseLanguage();
        if (result2 != null && baseLanguage == result2.third) {
            return (PsiElement)result2.second;
        }
        return viewProvider.findElementAt(offset, baseLanguage);
    }

    private static void probeElementsUp(@NotNull PsiElement element2, @NotNull PsiFile hostPsiFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement current2;
        if ((element2 = InjectedLanguageUtil.skipNonInjectablePsi(element2, probeUp)) == null) {
            return;
        }
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(hostPsiFile.getProject());
        InjectionResult result2 = null;
        for (current2 = element2; current2 != null && current2 != hostPsiFile && !(current2 instanceof PsiDirectory); current2 = current2.getParent()) {
            ProgressManager.checkCanceled();
            if ("EL".equals(current2.getLanguage().getID())) break;
            result2 = (InjectionResult)SoftReference.deref((Getter)((Getter)current2.getUserData(INJECTED_PSI)));
            if (result2 == null || !result2.isModCountUpToDate() || !result2.isValid()) {
                result2 = injectedManager.processInPlaceInjectorsFor(hostPsiFile, current2);
                InjectedLanguageUtil.preventResultFromGCWhileInjectedPsiIsReachable(result2);
            }
            if (result2 == null) continue;
            if (result2.files != null) {
                for (PsiFile psiFile : result2.files) {
                    boolean intersects;
                    Place place = InjectedLanguageUtil.getShreds(psiFile);
                    if (!place.isValid() || !(intersects = InjectedLanguageUtil.intersects(element2, place))) continue;
                    visitor.visit(psiFile, (List)((Object)place));
                }
            }
            if (result2.references == null || !(visitor instanceof InjectedReferenceVisitor)) break;
            InjectedReferenceVisitor refVisitor = (InjectedReferenceVisitor)visitor;
            for (Pair<ReferenceInjector, Place> pair : result2.references) {
                boolean intersects;
                Place place = (Place)((Object)pair.getSecond());
                if (!place.isValid() || !(intersects = InjectedLanguageUtil.intersects(element2, place))) continue;
                ReferenceInjector injector = (ReferenceInjector)pair.getFirst();
                refVisitor.visitInjectedReference(injector, (List<? extends PsiLanguageInjectionHost.Shred>)((Object)place));
            }
            break;
        }
        if (element2 != current2 && (probeUp || result2 != null)) {
            InjectedLanguageUtil.cacheResults(element2, current2, hostPsiFile, result2);
        }
    }

    private static void cacheResults(@NotNull PsiElement from, @Nullable PsiElement upUntil, @NotNull PsiFile hostFile, @Nullable InjectionResult result2) {
        InjectionResult cachedRef = result2 == null || result2.isEmpty() ? InjectedLanguageUtil.getEmptyInjectionResult(hostFile) : new SoftReference((Object)result2);
        for (PsiElement e = from; e != upUntil && e != null; e = e.getParent()) {
            ProgressManager.checkCanceled();
            e.putUserData(INJECTED_PSI, (Object)cachedRef);
        }
    }

    private static void preventResultFromGCWhileInjectedPsiIsReachable(@Nullable InjectionResult result2) {
        if (result2 != null && result2.files != null) {
            for (PsiFile psiFile : result2.files) {
                psiFile.getViewProvider().putUserData(INJECTION_HOLDER_BACK_REFERENCE, (Object)result2);
            }
        }
    }

    @NotNull
    private static InjectionResult getEmptyInjectionResult(@NotNull PsiFile host) {
        return (InjectionResult)CachedValuesManager.getCachedValue((PsiElement)host, () -> CachedValueProvider.Result.createSingleDependency((Object)new InjectionResult(host, null, null), (Object)PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private static PsiElement skipNonInjectablePsi(@NotNull PsiElement element2, boolean probeUp) {
        if (!InjectedLanguageUtil.stopLookingForInjection(element2) && element2.getFirstChild() == null) {
            if (!probeUp) {
                return null;
            }
            for (element2 = element2.getParent(); element2 != null && !InjectedLanguageUtil.stopLookingForInjection(element2) && element2.getFirstChild() == element2.getLastChild(); element2 = element2.getParent()) {
            }
        }
        return element2;
    }

    private static boolean stopLookingForInjection(@NotNull PsiElement element2) {
        return element2 instanceof PsiFileSystemItem || element2 instanceof PsiLanguageInjectionHost;
    }

    private static boolean intersects(@NotNull PsiElement hostElement, @NotNull Place place) {
        TextRange hostElementRange = hostElement.getTextRange();
        boolean intersects = false;
        Iterator iterator2 = place.iterator();
        while (iterator2.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator2.next();
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null || !shredHost.getTextRange().intersects(hostElementRange)) continue;
            intersects = true;
            break;
        }
        return intersects;
    }

    static PsiElement findInjectedElementNoCommit(@NotNull PsiFile hostFile, int offset) {
        if (hostFile instanceof PsiCompiledElement) {
            return null;
        }
        Project project = hostFile.getProject();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(hostFile)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Trinity<PsiElement, PsiElement, Language> result2 = InjectedLanguageUtil.tryOffset(hostFile, offset, documentManager);
        return (PsiElement)result2.first;
    }

    @NotNull
    private static Trinity<PsiElement, PsiElement, Language> tryOffset(@NotNull PsiFile hostFile, int offset, @NotNull PsiDocumentManager documentManager) {
        FileViewProvider provider = hostFile.getViewProvider();
        Language leafLanguage = null;
        PsiElement leafElement = null;
        for (Language language : provider.getLanguages()) {
            PsiElement injected;
            PsiElement leftElement;
            PsiElement element2 = provider.findElementAt(offset, language);
            if (element2 != null) {
                PsiElement injected2;
                if (leafLanguage == null) {
                    leafLanguage = language;
                    leafElement = element2;
                }
                if ((injected2 = InjectedLanguageUtil.findInside(element2, hostFile, offset, documentManager)) != null) {
                    return Trinity.create((Object)injected2, (Object)element2, (Object)language);
                }
            }
            if (offset == 0 || element2 != null && element2.getTextRange().getStartOffset() != offset || (leftElement = provider.findElementAt(offset - 1, language)) == null || leftElement.getTextRange().getEndOffset() != offset || (injected = InjectedLanguageUtil.findInside(leftElement, hostFile, offset, documentManager)) == null) continue;
            return Trinity.create((Object)injected, (Object)element2, (Object)language);
        }
        return Trinity.create(null, leafElement, leafLanguage);
    }

    private static PsiElement findInside(@NotNull PsiElement element2, @NotNull PsiFile hostFile, int hostOffset, @NotNull PsiDocumentManager documentManager) {
        Ref out = new Ref();
        InjectedLanguageUtil.enumerate(element2, hostFile, true, (injectedPsi, places) -> {
            for (PsiLanguageInjectionHost.Shred place : places) {
                TextRange hostRange = place.getHost().getTextRange();
                if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(hostOffset)) continue;
                DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                if (document == null) {
                    return;
                }
                int injectedOffset = document.hostToInjected(hostOffset);
                PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                out.set(injElement == null ? injectedPsi : injElement);
            }
        });
        return (PsiElement)out.get();
    }

    @Deprecated
    @NotNull
    public static ConcurrentList<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        List injected = (List)hostPsiFile.getUserData(INJECTED_DOCS_KEY);
        if (injected == null) {
            injected = (List)((UserDataHolderEx)hostPsiFile).putUserDataIfAbsent(INJECTED_DOCS_KEY, (Object)ContainerUtil.createConcurrentList());
        }
        return (ConcurrentList)injected;
    }

    @NotNull
    static List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile hostPsiFile, @NotNull TextRange range2) {
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        return ContainerUtil.filter(injected, inj -> Arrays.stream(inj.getHostRanges()).anyMatch(arg_0 -> ((TextRange)range2).intersects(arg_0)));
    }

    static void clearCachedInjectedFragmentsForFile(@NotNull PsiFile file2) {
        file2.putUserData(INJECTED_DOCS_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches(@NotNull PsiFile injected, @NotNull DocumentWindowImpl documentWindow) {
        VirtualFileWindowImpl virtualFile = (VirtualFileWindowImpl)injected.getVirtualFile();
        PsiManagerEx psiManagerEx = (PsiManagerEx)injected.getManager();
        if (psiManagerEx.getProject().isDisposed()) {
            return;
        }
        DebugUtil.performPsiModification("injected clearCaches", () -> psiManagerEx.getFileManager().setViewProvider((VirtualFile)virtualFile, null));
        VirtualFile delegate = virtualFile.getDelegate();
        if (!delegate.isValid()) {
            return;
        }
        FileViewProvider viewProvider = psiManagerEx.getFileManager().findCachedViewProvider(delegate);
        if (viewProvider == null) {
            return;
        }
        for (PsiFile hostFile : ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles()) {
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                ConcurrentList<DocumentWindow> cachedInjectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(hostFile);
                for (int i2 = cachedInjectedDocuments.size() - 1; i2 >= 0; --i2) {
                    DocumentWindow cachedInjectedDocument = (DocumentWindow)cachedInjectedDocuments.get(i2);
                    if (cachedInjectedDocument != documentWindow) continue;
                    cachedInjectedDocuments.remove(i2);
                }
            }
        }
    }

    public static Editor openEditorFor(@NotNull PsiFile file2, @NotNull Project project) {
        Editor editor;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow || editor.isDisposed()) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            return EditorWindowImpl.create((DocumentWindowImpl)document, (EditorImpl)editor, file2);
        }
        return editor;
    }

    @Deprecated
    public static PsiFile getTopLevelFile(@NotNull PsiElement element2) {
        PsiLanguageInjectionHost host;
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider && (host = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile)) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor) {
        return editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
    }

    public static boolean isInInjectedLanguagePrefixSuffix(@NotNull PsiElement element2) {
        PsiFile injectedFile = element2.getContainingFile();
        if (injectedFile == null) {
            return false;
        }
        Project project = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)project);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element2.getTextRange();
        List edibles = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEdiblesLength = edibles.stream().mapToInt(TextRange::getLength).sum();
        return combinedEdiblesLength != elementRange.getLength();
    }

    public static int hostToInjectedUnescaped(DocumentWindow window, int hostOffset) {
        Place shreds = ((DocumentWindowImpl)window).getShreds();
        Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getHostRangeMarker();
        if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
            return ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix().length();
        }
        StringBuilder chars = new StringBuilder();
        int unescaped = 0;
        for (int i2 = 0; i2 < shreds.size(); ++i2) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i2);
            int prefixLength = shred.getPrefix().length();
            int suffixLength = shred.getSuffix().length();
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            LiteralTextEscaper escaper = host == null ? null : host.createLiteralTextEscaper();
            unescaped += prefixLength;
            Segment currentRange = shred.getHostRangeMarker();
            if (currentRange != null) {
                Segment nextRange;
                Segment segment = nextRange = i2 == shreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)shreds.get(i2 + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    hostOffset = Math.min(hostOffset, currentRange.getEndOffset());
                    int inHost = hostOffset - currentRange.getStartOffset();
                    if (escaper != null && escaper.decode(rangeInsideHost, chars)) {
                        int found = ObjectUtils.binarySearch((int)0, (int)inHost, index -> Comparing.compare((int)escaper.getOffsetInHost(index, TextRange.create((int)0, (int)host.getTextLength())), (int)inHost));
                        return unescaped + (found >= 0 ? found : -found - 1);
                    }
                    return unescaped + inHost;
                }
                unescaped = escaper != null && escaper.decode(rangeInsideHost, chars) ? (unescaped += chars.length()) : (unescaped += currentRange.getEndOffset() - currentRange.getStartOffset());
                unescaped += suffixLength;
            }
            chars.setLength(0);
        }
        return unescaped - ((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix().length();
    }

    @Deprecated
    public static boolean hasInjections(@NotNull PsiLanguageInjectionHost host) {
        if (!host.isPhysical()) {
            return false;
        }
        Ref result2 = Ref.create((Object)false);
        InjectedLanguageUtil.enumerate((PsiElement)host, (injectedPsi, places) -> result2.set((Object)true));
        return (Boolean)result2.get();
    }

    public static String getUnescapedText(@NotNull PsiFile file2, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file2.getProject());
        if (manager.getInjectionHost((PsiElement)file2) == null) {
            return file2.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file2.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element2 == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element2.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtil.getUnescapedLeafText(element2, false));
                } else {
                    super.visitElement(element2);
                }
            }
        });
        return sb.toString();
    }

    @Nullable
    public static String getUnescapedLeafText(PsiElement element2, boolean strict) {
        String unescaped = (String)element2.getCopyableUserData(LeafPatcher.UNESCAPED_TEXT);
        if (unescaped != null) {
            return unescaped;
        }
        if (!strict && element2.getFirstChild() == null) {
            return element2.getText();
        }
        return null;
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element2) {
        PsiFile file2 = element2.getContainingFile();
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)virtualFile).getDocumentWindow();
        }
        return null;
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextRange().getStartOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, int offset) {
        Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate((PsiElement)injectionHost, (injectedPsi, places) -> ref.set((Object)injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places))));
        return (PsiElement)ref.get();
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable PsiElement psi) {
        if (psi == null) {
            return null;
        }
        PsiFile containingFile = psi.getContainingFile().getOriginalFile();
        PsiElement fileContext = containingFile.getContext();
        if (fileContext instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)fileContext;
        }
        Place shreds = InjectedLanguageUtil.getShreds(containingFile.getViewProvider());
        if (shreds == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            if (virtualFile instanceof VirtualFileWindow) {
                shreds = InjectedLanguageUtil.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow());
            }
        }
        return shreds != null ? (PsiLanguageInjectionHost)shreds.getHostPointer().getElement() : null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable VirtualFile virtualFile) {
        return virtualFile instanceof VirtualFileWindow ? (PsiLanguageInjectionHost)InjectedLanguageUtil.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow()).getHostPointer().getElement() : null;
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element2, @NotNull Language language, @NotNull Key<T> key, @Nullable T value2) {
        PsiFile file2 = InjectedLanguageUtil.getCachedInjectedFileWithLanguage(element2, language);
        if (file2 != null) {
            file2.putUserData(key, value2);
        }
    }

    @Deprecated
    public static <T> void putInjectedFileUserData(MultiHostRegistrar registrar, Key<T> key, T value2) {
        DeprecatedMethodException.report((String)"use putInjectedFileUserData(PsiElement, Language, Key, Object)} instead");
        InjectionResult result2 = ((InjectionRegistrarImpl)registrar).getInjectedResult();
        if (result2 != null && result2.files != null) {
            List<? extends PsiFile> files2 = result2.files;
            PsiFile file2 = files2.get(files2.size() - 1);
            file2.putUserData(key, value2);
        }
    }

    @Nullable
    public static PsiFile getCachedInjectedFileWithLanguage(@NotNull PsiElement element2, @NotNull Language language) {
        if (!element2.isValid()) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        return InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getCachedInjectedDocumentsInRange(containingFile, element2.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance((Project)containingFile.getProject()).getPsiFile((Document)documentWindow)).filter(file2 -> file2 != null && file2.getLanguage() == LanguageSubstitutors.getInstance().substituteLanguage(language, file2.getVirtualFile(), file2.getProject())).max(Comparator.comparingInt(PsiElement::getTextLength)).orElse(null);
    }

    public static void injectReference(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        ((InjectionRegistrarImpl)registrar).injectReference(language, prefix, suffix, host, rangeInsideHost);
    }

    public static BooleanRunnable reparse(@NotNull PsiFile injectedPsiFile, @NotNull DocumentWindow injectedDocument, @NotNull PsiFile hostPsiFile, @NotNull Document hostDocument, @NotNull FileViewProvider hostViewProvider, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        VirtualFile hostVirtualFile;
        InjectedFileViewProvider provider;
        VirtualFile oldInjectedVFile;
        Language language = injectedPsiFile.getLanguage();
        BooleanRunnable runnable2 = InjectionRegistrarImpl.reparse(language, (DocumentWindowImpl)injectedDocument, injectedPsiFile, (VirtualFileWindow)(oldInjectedVFile = (provider = (InjectedFileViewProvider)injectedPsiFile.getViewProvider()).getVirtualFile()), hostVirtualFile = hostViewProvider.getVirtualFile(), hostPsiFile, (DocumentEx)hostDocument, indicator, oldRoot, newRoot, documentManager);
        if (runnable2 == null) {
            EditorWindowImpl.disposeEditorFor(injectedDocument);
        }
        return runnable2;
    }

    public static class TokenInfo {
        @NotNull
        public final IElementType type;
        @NotNull
        public final ProperTextRange rangeInsideInjectionHost;
        public final int shredIndex;
        public final TextAttributes attributes;

        public TokenInfo(@NotNull IElementType type, @NotNull ProperTextRange rangeInsideInjectionHost, int shredIndex, @NotNull TextAttributes attributes) {
            this.type = type;
            this.rangeInsideInjectionHost = rangeInsideInjectionHost;
            this.shredIndex = shredIndex;
            this.attributes = attributes;
        }
    }
}

