/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.psi.impl.source.tree.injected.FoldingModelWindow;
import com.intellij.psi.impl.source.tree.injected.RangeMarkerWindow;
import org.jetbrains.annotations.NotNull;

public class FoldingRegionWindow
extends RangeMarkerWindow
implements FoldRegion {
    private final EditorWindow myEditorWindow;
    private final FoldRegion myHostRegion;

    FoldingRegionWindow(@NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow, @NotNull FoldRegion hostRegion, int startShift, int endShift) {
        super(documentWindow, (RangeMarkerEx)hostRegion, startShift, endShift);
        this.myEditorWindow = editorWindow;
        this.myHostRegion = hostRegion;
    }

    public boolean isExpanded() {
        return this.myHostRegion.isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.myHostRegion.setExpanded(expanded);
    }

    @NotNull
    public String getPlaceholderText() {
        return this.myHostRegion.getPlaceholderText();
    }

    public Editor getEditor() {
        return this.myEditorWindow;
    }

    public FoldingGroup getGroup() {
        return this.myHostRegion.getGroup();
    }

    public boolean shouldNeverExpand() {
        return false;
    }

    @Override
    public FoldRegionImpl getDelegate() {
        return (FoldRegionImpl)this.myHostRegion;
    }

    public void setGutterMarkEnabledForSingleLine(boolean value2) {
        this.myHostRegion.setGutterMarkEnabledForSingleLine(value2);
    }

    public boolean isGutterMarkEnabledForSingleLine() {
        return this.myHostRegion.isGutterMarkEnabledForSingleLine();
    }

    public void setPlaceholderText(@NotNull String text) {
        this.myHostRegion.setPlaceholderText(text);
    }

    public static FoldingRegionWindow getInjectedRegion(@NotNull FoldRegion hostRegion) {
        return (FoldingRegionWindow)hostRegion.getUserData(FoldingModelWindow.FOLD_REGION_WINDOW);
    }
}

