/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightTreeUtil {
    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type) {
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i2);
            if (child2.getTokenType() != type) continue;
            return child2;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types) {
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i2);
            if (!types.contains(child2.getTokenType())) continue;
            return child2;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        LighterASTNode child2 = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child2 != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child2;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        LighterASTNode child2 = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child2 != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child2;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        SmartList result2 = null;
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i2);
            if (child2.getTokenType() != type) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child2);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        List children2 = tree.getChildren(node);
        SmartList result2 = null;
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i2);
            if (!types.contains(child2.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child2);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        int length = node.getEndOffset() - node.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        return buffer.toString();
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LightTreeUtil.toBuffer(tree, (LighterASTNode)children2.get(i2), buffer, skipTypes);
        }
    }

    @Nullable
    public static LighterASTNode getParentOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types, @NotNull TokenSet stopAt) {
        if (node == null) {
            return null;
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type = node.getTokenType();
            if (types.contains(type)) {
                return node;
            }
            if (stopAt.contains(type)) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    public static void processLeavesAtOffsets(int[] offsets2, @NotNull LighterAST tree, final @NotNull BiConsumer<? super LighterASTTokenNode, ? super Integer> consumer) {
        if (offsets2.length == 0) {
            return;
        }
        final int[] sortedOffsets = (int[])offsets2.clone();
        Arrays.sort(sortedOffsets);
        new RecursiveLighterASTNodeWalkingVisitor(tree){
            int nextIndex;
            int nextOffset;
            {
                super(ast);
                this.nextIndex = 0;
                this.nextOffset = sortedOffsets[0];
            }

            @Override
            public void visitNode(@NotNull LighterASTNode element2) {
                if (this.containsNextOffset(element2)) {
                    super.visitNode(element2);
                }
            }

            @Override
            public void visitTokenNode(@NotNull LighterASTTokenNode node) {
                if (this.containsNextOffset((LighterASTNode)node)) {
                    consumer.accept(node, this.nextOffset);
                    while (this.containsNextOffset((LighterASTNode)node)) {
                        this.advanceOffset();
                    }
                }
            }

            private boolean containsNextOffset(@NotNull LighterASTNode element2) {
                ProgressManager.checkCanceled();
                return this.nextIndex < sortedOffsets.length && element2.getStartOffset() <= this.nextOffset && this.nextOffset < element2.getEndOffset();
            }

            private void advanceOffset() {
                ++this.nextIndex;
                if (this.nextIndex < sortedOffsets.length) {
                    this.nextOffset = sortedOffsets[this.nextIndex];
                }
            }
        }.visitNode(tree.getRoot());
    }
}

