/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LeafPsiElement
extends LeafElement
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance(LeafPsiElement.class);

    public LeafPsiElement(@NotNull IElementType type, CharSequence text) {
        super(type, text);
    }

    public PsiElement @NotNull [] getChildren() {
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getFirstChild() {
        return null;
    }

    public PsiElement getLastChild() {
        return null;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
    }

    public PsiElement getParent() {
        return SharedImplUtil.getParent(this);
    }

    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    public PsiFile getContainingFile() {
        PsiFile file2 = SharedImplUtil.getContainingFile(this);
        if (file2 == null || !file2.isValid()) {
            this.invalid();
        }
        return file2;
    }

    @Contract(value="-> fail")
    private void invalid() {
        ProgressIndicatorProvider.checkCanceled();
        StringBuilder builder2 = new StringBuilder();
        for (TreeElement element2 = this; element2 != null; element2 = element2.getTreeParent()) {
            if (element2 != this) {
                builder2.append(" / ");
            }
            builder2.append(element2.getClass().getName()).append(':').append(element2.getElementType());
        }
        throw new PsiInvalidElementAccessException((PsiElement)this, builder2.toString());
    }

    public PsiElement findElementAt(int offset) {
        return this;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    public PsiReference getReference() {
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        return SharedPsiElementImplUtil.getReferences(this);
    }

    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitElement((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean isPhysical() {
        PsiFile file2 = this.getContainingFile();
        return file2 != null && file2.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return ResolveScopeManager.getElementResolveScope(this);
    }

    @NotNull
    public SearchScope getUseScope() {
        return ResolveScopeManager.getElementUseScope(this);
    }

    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return project;
        }
        PsiManager manager = this.getManager();
        if (manager == null) {
            this.invalid();
        }
        return manager.getProject();
    }

    @NotNull
    public Language getLanguage() {
        return this.getElementType().getLanguage();
    }

    public ASTNode getNode() {
        return this;
    }

    @Override
    public PsiElement getPsi() {
        return this;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

