/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.text.StringFactory;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance(CompositeElement.class);
    public static final CompositeElement[] EMPTY_ARRAY = new CompositeElement[0];
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength = -1;
    private volatile int myHC = -1;
    private volatile PsiElement myWrapper;
    private static final boolean ASSERT_THREADING = true;
    private static final AtomicFieldUpdater<CompositeElement, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(CompositeElement.class, PsiElement.class);

    public CompositeElement(@NotNull IElementType type) {
        super(type);
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (TreeElement child2 = this.rawFirstChild(); child2 != null; child2 = child2.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child2.clone());
        }
        clone.clearCaches();
        return clone;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
            CompositeElement.assertThreading((PsiFile)psi);
        }
    }

    @Override
    public void clearCaches() {
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private static void assertThreading(@NotNull PsiFile file2) {
        boolean ok;
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || CompositeElement.isNonPhysicalOrInjected(file2);
        if (!ok) {
            LOG.error("Threading assertion. " + CompositeElement.getThreadingDiagnostics(file2));
        }
    }

    private static String getThreadingDiagnostics(@NotNull PsiFile psiFile) {
        return "psiFile: " + psiFile + "; psiFile.getViewProvider(): " + psiFile.getViewProvider() + "; psiFile.isPhysical(): " + psiFile.isPhysical() + "; nonPhysicalOrInjected: " + CompositeElement.isNonPhysicalOrInjected(psiFile);
    }

    private static boolean isNonPhysicalOrInjected(@NotNull PsiFile psiFile) {
        return psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(@NotNull TreeElementVisitor visitor) {
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element2 = this;
        if (element2.getTreeParent() == null && offset >= element2.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child2 = ((TreeElement)element2).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element2).getLastChildNode();
            int elementTextLength = element2.getTextLength();
            boolean bl = fwd = lastChild == null || elementTextLength / 2 > offset;
            if (!fwd) {
                child2 = lastChild;
                offset = elementTextLength - offset;
            }
            while (child2 != null) {
                int textLength = child2.getTextLength();
                if (textLength > offset || !fwd && textLength >= offset) {
                    if (child2 instanceof LeafElement) {
                        if (child2 instanceof ForeignLeafPsiElement) {
                            child2 = fwd ? child2.getTreeNext() : child2.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child2;
                    }
                    offset = fwd ? offset : textLength - offset;
                    element2 = child2;
                    continue block0;
                }
                offset -= textLength;
                child2 = fwd ? child2.getTreeNext() : child2.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull IElementType type) {
        ASTNode node = this.findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull TokenSet types) {
        ASTNode node = this.findChildByType(types);
        return node == null ? null : node.getPsi();
    }

    public ASTNode findChildByType(@NotNull IElementType type) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (TreeElement element2 = this.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (element2.getElementType() != type) continue;
            return element2;
        }
        return null;
    }

    public ASTNode findChildByType(@NotNull IElementType type, ASTNode anchor2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, type);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (TreeElement element2 = this.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (!types.contains(element2.getElementType())) continue;
            return element2;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, typesSet);
    }

    @NotNull
    public String getText() {
        return StringFactory.createShared((char[])this.textToCharArray());
    }

    @NotNull
    public CharSequence getChars() {
        return this.getText();
    }

    @Override
    public char @NotNull [] textToCharArray() {
        int endOffset;
        this.assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + CompositeElement.isNonPhysicalOrInjected(SharedImplUtil.getContainingFile(this));
        msg = msg + ";\n buffer=" + text;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file2;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file2 = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file2;
                msg = msg + ";\n psi.file.tl=" + file2.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file2.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file2.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                PsiElement fileLeaf = file2.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    public boolean textContains(char c) {
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (!child2.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start2) {
        final int[] curOffset = new int[]{start2};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element2 = this.findChildByRole(role);
        if (element2 == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element2);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (this.getChildRole(child2) != role) continue;
            return child2;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child2) {
        LOG.assertTrue(child2.getTreeParent() == this, (Object)child2);
        return 0;
    }

    protected final int getChildRole(@NotNull ASTNode child2, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child2) {
            return roleCandidate;
        }
        return 0;
    }

    public ASTNode @NotNull [] getChildren(@Nullable TokenSet filter2) {
        int count = this.countChildren(filter2);
        if (count == 0) {
            return EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child2.getElementType())) continue;
            result2[count++] = child2;
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@Nullable TokenSet filter2, @NotNull ArrayFactory<? extends T> constructor) {
        this.assertReadAccessAllowed();
        int count = this.countChildren(filter2);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            return result2;
        }
        int idx = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null && idx < count; child2 = child2.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child2.getElementType())) continue;
            PsiElement element2 = child2.getPsi();
            LOG.assertTrue(element2 != null, (Object)child2);
            result2[idx++] = element2;
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@NotNull IElementType type, @NotNull ArrayFactory<? extends T> constructor) {
        this.assertReadAccessAllowed();
        int count = this.countChildren(type);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            return result2;
        }
        int idx = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null && idx < count; child2 = child2.getTreeNext()) {
            if (type != child2.getElementType()) continue;
            PsiElement element2 = child2.getPsi();
            LOG.assertTrue(element2 != null, (Object)child2);
            result2[idx++] = element2;
        }
        return result2;
    }

    public int countChildren(@Nullable TokenSet filter2) {
        int count = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child2.getElementType())) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(@NotNull IElementType type) {
        int count = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (type != child2.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, @Nullable ASTNode anchor2, @Nullable Boolean before) {
        Object anchorBefore = anchor2 == null ? (before == null || before != false ? null : this.getFirstChildNode()) : (before != false ? anchor2 : anchor2.getTreeNext());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child2) {
        CodeEditUtil.removeChild(this, child2);
    }

    public void replaceChildInternal(@NotNull ASTNode child2, @NotNull TreeElement newElement) {
        CodeEditUtil.replaceChild(this, child2, newElement);
    }

    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        this.assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child2 = this.firstChild; child2 != null; child2 = child2.getTreeNext()) {
                hc += child2.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start2) {
        TreeElement child2;
        TreeElement cur = start2;
        while (cur.getCachedLength() < 0 && (child2 = cur.getFirstChildNode()) != null) {
            cur = child2;
        }
        return cur;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child2 = cur.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                    length += child2.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : CompositeElement.getNotNullParent(cur);
        }
    }

    private static TreeElement getNotNullParent(TreeElement cur) {
        CompositeElement parent = cur.getTreeParent();
        if (parent == null) {
            CompositeElement.diagnoseNullParent(cur);
        }
        return parent;
    }

    private static void diagnoseNullParent(TreeElement cur) {
        PsiElement psi = cur.getPsi();
        if (psi != null) {
            PsiUtilCore.ensureValid((PsiElement)psi);
        }
        throw new IllegalStateException("Null parent of " + cur + " " + cur.getClass());
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    public void addChild(@NotNull ASTNode child2, @Nullable ASTNode anchorBefore) {
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, (Object)"anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child2);
        TreeElement last = ((TreeElement)child2).getTreeNext();
        TreeElement first = (TreeElement)child2;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            if (anchorBefore != null) {
                CompositeElement.insertBefore((TreeChangeEventImpl)destinationTreeChange, (TreeElement)anchorBefore, first);
            } else {
                CompositeElement.add((TreeChangeEventImpl)destinationTreeChange, this, first);
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, @NotNull CharSequence leafText, ASTNode anchorBefore) {
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child2) {
        this.addChild(child2, null);
    }

    public void removeChild(@NotNull ASTNode child2) {
        CompositeElement.removeChildInner((TreeElement)child2);
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            CompositeElement.replace((TreeChangeEventImpl)destinationTreeChange, oldChild1, newChild1);
            CompositeElement.repairRemovedElement(this, oldChild1);
        }, this);
    }

    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(event -> CompositeElement.remove((TreeChangeEventImpl)event, (TreeElement)anotherParent.getFirstChildNode(), null), (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                TreeElement first = this.getFirstChildNode();
                TreeChangeEventImpl event = (TreeChangeEventImpl)destinationTreeChange;
                CompositeElement parent = this.getTreeParent();
                if (parent != null) {
                    event.addElementaryChange(parent);
                }
                CompositeElement.remove(event, first, null);
                CompositeElement.add(event, this, (TreeElement)firstChild);
                if (parent != null) {
                    CompositeElement.repairRemovedElement(this, first);
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child2 = this.getFirstChildNode();
        if (child2 != null) {
            this.removeRange(child2, null);
        }
    }

    public void addChildren(@NotNull ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        ASTNode f = firstChild;
        while (f != lastChild) {
            ASTNode next = f.getTreeNext();
            this.addChild(f, anchorBefore);
            f = next;
        }
    }

    @Nullable
    final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper2 = this.myWrapper;
        if (wrapper2 != null) {
            return wrapper2;
        }
        wrapper2 = this.createPsiNoLock();
        return ourPsiUpdater.compareAndSet((Object)this, null, (Object)wrapper2) ? wrapper2 : Objects.requireNonNull(this.myWrapper);
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement((ASTNode)this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        PsiElement prev = this.myWrapper;
        if (prev != null && prev != psi) {
            DebugUtil.onInvalidated(prev);
        }
        this.myWrapper = psi;
    }

    void clearPsi() {
        this.myWrapper = null;
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        TreeElement last = this.getLastChildNode();
        if (last == null) {
            TreeElement chainLast = CompositeElement.rawSetParents(first, this);
            this.setFirstChildNode(first);
            this.setLastChildNode(chainLast);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    @NotNull
    static TreeElement rawSetParents(@NotNull TreeElement child2, @NotNull CompositeElement parent) {
        child2.rawRemoveUpToWithoutNotifications(null, false);
        while (true) {
            child2.setTreeParent(parent);
            TreeElement treeNext = child2.getTreeNext();
            if (treeNext == null) {
                return child2;
            }
            child2 = treeNext;
        }
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(@NotNull CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull CompositeElement parent, @NotNull TreeElement first) {
        destinationTreeChange.addElementaryChange(parent);
        parent.rawAddChildren(first);
    }

    private static void remove(@NotNull TreeChangeEventImpl destinationTreeChange, TreeElement first, TreeElement last) {
        if (first != null) {
            destinationTreeChange.addElementaryChange(first.getTreeParent());
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull TreeElement anchorBefore, @NotNull TreeElement first) {
        destinationTreeChange.addElementaryChange(anchorBefore.getTreeParent());
        anchorBefore.rawInsertBeforeMe(first);
    }

    private static void replace(@NotNull TreeChangeEventImpl sourceTreeChange, @NotNull TreeElement oldChild, @NotNull TreeElement newChild) {
        sourceTreeChange.addElementaryChange(oldChild.getTreeParent());
        oldChild.rawReplaceWithList(newChild);
    }

    private static void removeChildInner(@NotNull TreeElement child2) {
        CompositeElement.removeChildrenInner(child2, child2.getTreeNext());
    }

    private static void removeChildrenInner(@NotNull TreeElement first, TreeElement last) {
        FileElement fileElement = TreeUtil.getFileElement(first);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                CompositeElement.remove((TreeChangeEventImpl)destinationTreeChange, first, last);
                CompositeElement.repairRemovedElement(fileElement, first);
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }
}

