/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CharTable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeUtil {
    private static final Logger LOG = Logger.getInstance(ChangeUtil.class);

    public static void encodeInformation(TreeElement element2) {
        ChangeUtil.encodeInformation(element2, element2);
    }

    private static void encodeInformation(TreeElement element2, ASTNode original) {
        DebugUtil.performPsiModification(null, () -> ChangeUtil.encodeInformation(element2, original, new HashMap<Object, Object>()));
    }

    private static void encodeInformation(TreeElement element2, ASTNode original, Map<Object, Object> state) {
        for (TreeCopyHandler handler2 : TreeCopyHandler.EP_NAME.getExtensionList()) {
            handler2.encodeInformation(element2, original, state);
        }
        if (original instanceof CompositeElement) {
            TreeElement child2 = element2.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child2 != null) {
                ChangeUtil.encodeInformation(child2, child1, state);
                child2 = child2.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    public static TreeElement decodeInformation(TreeElement element2) {
        return (TreeElement)DebugUtil.performPsiModification(null, () -> ChangeUtil.decodeInformation(element2, new HashMap<Object, Object>()));
    }

    private static TreeElement decodeInformation(TreeElement element2, Map<Object, Object> state) {
        for (TreeElement child2 = element2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            child2 = ChangeUtil.decodeInformation(child2, state);
        }
        return TreeCopyHandler.EP_NAME.getExtensionList().stream().map(handler2 -> handler2.decodeInformation(element2, state)).filter(Objects::nonNull).findFirst().orElse(element2);
    }

    @NotNull
    public static LeafElement copyLeafWithText(@NotNull LeafElement original, @NotNull String text) {
        LeafElement element2 = ASTFactory.leaf(original.getElementType(), text);
        original.copyCopyableDataTo(element2);
        ChangeUtil.encodeInformation(element2, original);
        TreeUtil.clearCaches(element2);
        ChangeUtil.saveIndentationToCopy(original, element2);
        return element2;
    }

    @NotNull
    public static TreeElement copyElement(@NotNull TreeElement original, CharTable table) {
        CompositeElement treeParent = original.getTreeParent();
        return ChangeUtil.copyElement(original, treeParent == null ? null : treeParent.getPsi(), table);
    }

    @NotNull
    public static TreeElement copyElement(@NotNull TreeElement original, PsiElement context, CharTable table) {
        TreeElement element2 = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element2, context, table).getTreeElement();
        ChangeUtil.encodeInformation(element2, original);
        TreeUtil.clearCaches(element2);
        ChangeUtil.saveIndentationToCopy(original, element2);
        return element2;
    }

    private static void saveIndentationToCopy(TreeElement original, TreeElement element2) {
        if (original == null || element2 == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element2, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    @NotNull
    public static TreeElement copyToElement(@NotNull PsiElement original) {
        DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage());
        FileElement holderElement = holder.getTreeElement();
        TreeElement treeElement = ChangeUtil.generateTreeElement(original, holderElement.getCharTable(), original.getManager());
        LOG.assertTrue(treeElement != null, (Object)("original element class: " + original.getClass().getName() + ", language: " + original.getLanguage()));
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        return treeElement;
    }

    @Nullable
    public static TreeElement generateTreeElement(@Nullable PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (original == null) {
            return null;
        }
        PsiUtilCore.ensureValid((PsiElement)original);
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        return TreeGenerator.EP_NAME.getExtensionList().stream().map(generator -> generator.generateTreeFor(original, table, manager)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static void prepareAndRunChangeAction(final @NotNull ChangeAction action2, final @NotNull TreeElement changedElement) {
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel((Project)manager.getProject());
        final TreeAspect treeAspect = (TreeAspect)model.getModelAspect(TreeAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(changedElement.getPsi(), treeAspect){

            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl(treeAspect, changedFile);
                event.registerChangeSet((PomModelAspect)treeAspect, (PomChangeSet)destinationTreeChange);
                action2.makeChange(destinationTreeChange);
                changedElement.clearCaches();
                if (changedElement instanceof CompositeElement) {
                    ((CompositeElement)changedElement).subtreeChanged();
                }
                return event;
            }
        });
    }

    @FunctionalInterface
    public static interface ChangeAction {
        public void makeChange(@NotNull TreeChangeEvent var1);
    }
}

