/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AstBufferUtil {
    private AstBufferUtil() {
    }

    public static int toBuffer(@NotNull ASTNode element2, char @Nullable [] buffer, int offset) {
        return AstBufferUtil.toBuffer(element2, buffer, offset, false);
    }

    public static int toBuffer(@NotNull ASTNode element2, char @Nullable [] buffer, int offset, boolean skipWhitespaceAndComments) {
        BufferVisitor visitor = new BufferVisitor(skipWhitespaceAndComments, skipWhitespaceAndComments, offset, buffer);
        ((TreeElement)element2).acceptTree(visitor);
        return visitor.end;
    }

    public static String getTextSkippingWhitespaceComments(@NotNull ASTNode element2) {
        int length = AstBufferUtil.toBuffer(element2, null, 0, true);
        char[] buffer = new char[length];
        AstBufferUtil.toBuffer(element2, buffer, 0, true);
        return StringFactory.createShared((char[])buffer);
    }

    public static class BufferVisitor
    extends RecursiveTreeElementWalkingVisitor {
        private final boolean skipWhitespace;
        private final boolean skipComments;
        protected final int offset;
        protected int end;
        protected final char[] buffer;

        public BufferVisitor(PsiElement element2, boolean skipWhitespace, boolean skipComments) {
            this(skipWhitespace, skipComments, 0, new char[element2.getTextLength()]);
            ((TreeElement)element2.getNode()).acceptTree(this);
        }

        public BufferVisitor(boolean skipWhitespace, boolean skipComments, int offset, char @Nullable [] buffer) {
            super(false);
            this.skipWhitespace = skipWhitespace;
            this.skipComments = skipComments;
            this.buffer = buffer;
            this.offset = offset;
            this.end = offset;
        }

        public int getEnd() {
            return this.end;
        }

        public char @NotNull [] getBuffer() {
            assert (this.buffer != null);
            return this.buffer;
        }

        public CharSequence createCharSequence() {
            assert (this.buffer != null);
            return new CharArrayCharSequence(this.buffer, this.offset, this.end);
        }

        @Override
        public void visitLeaf(LeafElement element2) {
            ProgressIndicatorProvider.checkCanceled();
            if (!this.isIgnored(element2)) {
                this.end = element2.copyTo(this.buffer, this.end);
            }
        }

        protected boolean isIgnored(LeafElement element2) {
            return element2 instanceof ForeignLeafPsiElement || this.skipWhitespace && element2 instanceof PsiWhiteSpace || this.skipComments && element2 instanceof PsiComment;
        }

        @Override
        public void visitComposite(CompositeElement composite) {
            if (composite instanceof LazyParseableElement) {
                LazyParseableElement lpe = (LazyParseableElement)composite;
                int lpeResult = lpe.copyTo(this.buffer, this.end);
                if (lpeResult >= 0) {
                    this.end = lpeResult;
                    return;
                }
                assert (lpe.isParsed());
            }
            super.visitComposite(composite);
        }
    }
}

