/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JpsFileTargetContextUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public static PsiFileReferenceHelper getInstance() {
        return (PsiFileReferenceHelper)Objects.requireNonNull(FileReferenceHelper.EP_NAME.findExtension(PsiFileReferenceHelper.class));
    }

    @Override
    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference2) {
        return FileReferenceQuickFixProvider.registerQuickFix(reference2);
    }

    @Override
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRootForFile = index.getSourceRootForFile(file2);
        if (contentRootForFile == null) {
            contentRootForFile = index.getContentRootForFile(file2);
        }
        if (contentRootForFile != null) {
            return PsiManager.getInstance((Project)project).findDirectory(contentRootForFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        return PsiFileReferenceHelper.getContextsForModule(module, "", module.getModuleWithDependenciesScope());
    }

    @Override
    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project, @NotNull VirtualFile file2, boolean isAbsoluteReference) {
        List<PsiFileSystemItem> contexts;
        if (isAbsoluteReference) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module module = index.getModuleForFile(file2);
            if (module == null) {
                return Collections.emptyList();
            }
            contexts = PsiFileReferenceHelper.getContextsForModule(module, "", module.getModuleWithDependenciesScope());
        } else {
            contexts = this.getContexts(project, file2, true);
        }
        ArrayList<FileTargetContext> fileTargetContexts = new ArrayList<FileTargetContext>();
        for (PsiFileSystemItem context : contexts) {
            if (context instanceof VirtualPsiDirectory) {
                VirtualPsiDirectory virtual = (VirtualPsiDirectory)context;
                fileTargetContexts.add(new FileTargetContext((PsiFileSystemItem)virtual.getRoot(), virtual.getPathToCreate()));
                continue;
            }
            fileTargetContexts.add(new FileTargetContext(context));
        }
        return JpsFileTargetContextUtils.prepareTargetContexts(project, file2, fileTargetContexts);
    }

    private static String[] removeCommonStartPackages(String[] path, String packagePath) {
        String existingPackage;
        String part;
        int i2;
        List packages = StringUtil.split((String)packagePath, (String)".");
        SmartList result2 = new SmartList();
        for (i2 = 0; i2 < packages.size() && i2 < path.length && Objects.equals(part = path[i2], existingPackage = (String)packages.get(i2)); ++i2) {
        }
        while (i2 < path.length) {
            result2.add(path[i2]);
            ++i2;
        }
        return ArrayUtil.toStringArray((Collection)result2);
    }

    private static String @NotNull [] getRelativePath(VirtualFile file2, VirtualFile root) {
        ArrayList<String> names2 = new ArrayList<String>();
        for (VirtualFile parent = file2; parent != null && !parent.equals(root); parent = parent.getParent()) {
            names2.add(parent.getName());
        }
        if (names2.isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] path = new String[names2.size()];
        for (int i2 = 0; i2 < names2.size(); ++i2) {
            path[i2] = (String)names2.get(names2.size() - i2 - 1);
        }
        return path;
    }

    @NotNull
    private static List<SourceFolder> getMissingTargetFolders(Module module, Collection<PsiFileSystemItem> contextsForModule) {
        ModuleRootManager model = ModuleRootManager.getInstance((Module)module);
        return (List)Arrays.stream(model.getContentEntries()).flatMap(contentEntry -> Arrays.stream(contentEntry.getSourceFolders())).filter(sourceFolder -> {
            if (sourceFolder.getFile() == null) {
                return false;
            }
            for (PsiFileSystemItem contextItem : contextsForModule) {
                if (!VfsUtilCore.isAncestor((VirtualFile)sourceFolder.getFile(), (VirtualFile)contextItem.getVirtualFile(), (boolean)false)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toCollection(SmartList::new));
    }

    private List<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file2, boolean includeMissingPackages) {
        PsiFileSystemItem parent;
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file2);
        if (item != null && (parent = item.getParent()) != null) {
            Module module;
            String path;
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile parentFile = parent.getVirtualFile();
            assert (parentFile != null);
            VirtualFile root = index.getSourceRootForFile(parentFile);
            if (root != null && (path = VfsUtilCore.getRelativePath((VirtualFile)parentFile, (VirtualFile)root, (char)'.')) != null && (module = index.getModuleForFile(file2)) != null) {
                OrderEntry orderEntry = ModuleRootManager.getInstance((Module)module).getFileIndex().getOrderEntryForFile(file2);
                String rootPackagePrefix = PsiFileReferenceHelper.getSourceRootPackagePrefix(orderEntry, root);
                if (!rootPackagePrefix.isEmpty()) {
                    path = path + "." + rootPackagePrefix;
                }
                List<PsiFileSystemItem> contextsForModule = PsiFileReferenceHelper.getContextsForModule(module, path, module.getModuleWithDependenciesScope());
                if (!includeMissingPackages) {
                    return contextsForModule;
                }
                return PsiFileReferenceHelper.getAdditionalContexts(parentFile, root, module, contextsForModule);
            }
            return Collections.singletonList(parent);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<PsiFileSystemItem> getAdditionalContexts(@NotNull VirtualFile parentFile, @NotNull VirtualFile root, @NotNull Module module, @NotNull List<PsiFileSystemItem> contextsForModule) {
        List<SourceFolder> additionalSourceFolders = PsiFileReferenceHelper.getMissingTargetFolders(module, contextsForModule);
        if (additionalSourceFolders.isEmpty()) {
            return contextsForModule;
        }
        ArrayList<PsiFileSystemItem> joinedContexts = new ArrayList<PsiFileSystemItem>(contextsForModule.size() + additionalSourceFolders.size());
        joinedContexts.addAll(contextsForModule);
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        String[] relativePath = PsiFileReferenceHelper.getRelativePath(parentFile, root);
        for (SourceFolder sourceFolder : additionalSourceFolders) {
            PsiDirectory directory;
            if (sourceFolder.getFile() == null || (directory = manager.findDirectory(sourceFolder.getFile())) == null) continue;
            String srcPackagePrefix = sourceFolder.getPackagePrefix();
            String[] pathToCreate = srcPackagePrefix.isEmpty() ? relativePath : PsiFileReferenceHelper.removeCommonStartPackages(relativePath, srcPackagePrefix);
            joinedContexts.add(new VirtualPsiDirectory(directory, pathToCreate));
        }
        return joinedContexts;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file2) {
        return this.getContexts(project, file2, false);
    }

    private static String getSourceRootPackagePrefix(OrderEntry orderEntry, VirtualFile sourceRootOfFile) {
        if (orderEntry instanceof ModuleSourceOrderEntry) {
            for (ContentEntry e : ((ModuleSourceOrderEntry)orderEntry).getRootModel().getContentEntries()) {
                for (SourceFolder sf : e.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String s;
                    if (!sourceRootOfFile.equals(sf.getFile()) || (s = sf.getPackagePrefix()).isEmpty()) continue;
                    return s;
                }
            }
        }
        return "";
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInSourceContent(file2);
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        return url.trim();
    }

    static List<PsiFileSystemItem> getContextsForModule(@NotNull Module module, @NotNull String packageName, @Nullable GlobalSearchScope scope) {
        List<PsiFileSystemItem> result2 = null;
        Query<VirtualFile> query = DirectoryIndex.getInstance(module.getProject()).getDirectoriesByPackageName(packageName, false);
        PsiManager manager = null;
        for (VirtualFile file2 : query) {
            PsiDirectory psiDirectory;
            if (scope != null && !scope.contains(file2)) continue;
            if (result2 == null) {
                result2 = new ArrayList<PsiFileSystemItem>();
                manager = PsiManager.getInstance((Project)module.getProject());
            }
            if ((psiDirectory = manager.findDirectory(file2)) == null) continue;
            result2.add((PsiFileSystemItem)psiDirectory);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    private static class VirtualPsiDirectory
    extends SyntheticFileSystemItem {
        private final PsiDirectory myRoot;
        private final String[] myPathToCreate;

        private VirtualPsiDirectory(PsiDirectory root, String[] pathToCreate) {
            super(root.getProject());
            this.myRoot = root;
            this.myPathToCreate = pathToCreate;
        }

        @Nullable
        public PsiFileSystemItem getParent() {
            return this.myRoot;
        }

        public VirtualFile getVirtualFile() {
            return null;
        }

        private PsiDirectory getRoot() {
            return this.myRoot;
        }

        private String[] getPathToCreate() {
            return this.myPathToCreate;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myPathToCreate.length == 0 ? this.myRoot.getName() : this.myPathToCreate[this.myPathToCreate.length - 1];
        }

        public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
            return false;
        }
    }
}

