/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.TrackingReferenceRegistrar;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TDoubleObjectHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME);
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = new ConcurrentHashMap<Language, PsiReferenceRegistrarImpl>();

    public ReferenceProvidersRegistryImpl() {
        if (Extensions.getRootArea().hasExtensionPoint(PsiReferenceContributor.EP_NAME)) {
            PsiReferenceContributor.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedLazyInstance<PsiReferenceContributor>>(){

                public void extensionAdded(@NotNull KeyedLazyInstance<PsiReferenceContributor> extension, @NotNull PluginDescriptor pluginDescriptor) {
                    block4: {
                        PsiReferenceContributor instance;
                        Language language;
                        block3: {
                            language = Language.findLanguageByID((String)extension.getKey());
                            instance = (PsiReferenceContributor)extension.getInstance();
                            if (language != Language.ANY) break block3;
                            for (PsiReferenceRegistrarImpl registrar : ReferenceProvidersRegistryImpl.this.myRegistrars.values()) {
                                ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar, instance);
                            }
                            break block4;
                        }
                        if (language == null) break block4;
                        this.registerContributorForLanguageAndDialects(language, instance);
                        if (language instanceof MetaLanguage) {
                            Collection matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
                            for (Language matchingLanguage : matchingLanguages) {
                                this.registerContributorForLanguageAndDialects(matchingLanguage, instance);
                            }
                        }
                    }
                }

                private void registerContributorForLanguageAndDialects(Language language, PsiReferenceContributor instance) {
                    Set languageAndDialects = LanguageUtil.getAllDerivedLanguages((Language)language);
                    for (Language languageOrDialect : languageAndDialects) {
                        PsiReferenceRegistrarImpl registrar = (PsiReferenceRegistrarImpl)((Object)ReferenceProvidersRegistryImpl.this.myRegistrars.get(languageOrDialect));
                        if (registrar == null) continue;
                        ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar, instance);
                    }
                }

                public void extensionRemoved(@NotNull KeyedLazyInstance<PsiReferenceContributor> extension, @NotNull PluginDescriptor pluginDescriptor) {
                    Disposer.dispose((Disposable)((Disposable)extension.getInstance()));
                }
            }, (Disposable)ApplicationManager.getApplication());
        }
    }

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(@NotNull Language language) {
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl();
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguageOrAny(language)) {
            ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar, contributor);
        }
        List referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguageOrAny(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    return this.myProvider.getReferencesByElement(element2, context);
                }
            });
        }
        registrar.markInitialized();
        return registrar;
    }

    private static void registerContributedReferenceProviders(@NotNull PsiReferenceRegistrarImpl registrar, @NotNull PsiReferenceContributor contributor) {
        contributor.registerReferenceProviders((PsiReferenceRegistrar)new TrackingReferenceRegistrar(registrar, (Disposable)contributor));
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)contributor);
    }

    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        return this.myRegistrars.computeIfAbsent(language, ReferenceProvidersRegistryImpl::createRegistrar);
    }

    public void unloadProvidersFor(@NotNull Language language) {
        PsiReferenceRegistrarImpl psiReferenceRegistrar = this.myRegistrars.remove(language);
        if (psiReferenceRegistrar != null) {
            psiReferenceRegistrar.cleanup();
        }
        for (PsiReferenceRegistrarImpl registrar : this.myRegistrars.values()) {
            registrar.clearBindingsCache();
        }
    }

    protected PsiReference @NotNull [] doGetReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints2) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints2);
        TDoubleObjectHashMap<List<PsiReference[]>> allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context, providers);
        if (allReferencesMap.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        double maxPriority = Math.max(-100.0, Arrays.stream(allReferencesMap.keys()).max().getAsDouble());
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences((Collection)allReferencesMap.get(maxPriority));
        ContainerUtil.addAllNotNull((Collection)result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull((Collection)result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @NotNull
    private static TDoubleObjectHashMap<List<PsiReference[]>> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context, @NotNull List<? extends ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        TDoubleObjectHashMap map2 = new TDoubleObjectHashMap();
        for (ProviderBinding.ProviderInfo<ProcessingContext> providerInfo : providers) {
            Object[] refs = ReferenceProvidersRegistryImpl.getReferences(context, providerInfo);
            if ((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal()) && Registry.is((String)"ide.check.reference.provider.underlying.element")) {
                ReferenceProvidersRegistryImpl.assertReferenceUnderlyingElement(context, (PsiReference[])refs, providerInfo.provider);
            }
            if (refs.length <= 0) continue;
            List list2 = (List)map2.get(providerInfo.priority);
            if (list2 == null) {
                list2 = new SmartList();
                map2.put(providerInfo.priority, (Object)list2);
            }
            list2.add(refs);
            if (!IdempotenceChecker.isLoggingEnabled()) continue;
            IdempotenceChecker.logTrace(providerInfo.provider + " returned " + Arrays.toString(refs));
        }
        return map2;
    }

    private static void assertReferenceUnderlyingElement(@NotNull PsiElement context, PsiReference[] refs, PsiReferenceProvider provider) {
        for (PsiReference reference2 : refs) {
            if (reference2 != null) assert (reference2.getElement() == context) : "reference " + reference2 + " was created for " + context + " but target " + reference2.getElement() + ", provider " + provider;
        }
    }

    private static PsiReference @NotNull [] getReferences(@NotNull PsiElement context, @NotNull ProviderBinding.ProviderInfo<? extends ProcessingContext> providerInfo) {
        try {
            return providerInfo.provider.getReferencesByElement(context, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            return PsiReference.EMPTY_ARRAY;
        }
    }

    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull TDoubleObjectHashMap<List<PsiReference[]>> allReferencesMap, double maxPriority, @NotNull List<? extends PsiReference> maxPriorityRefs) {
        SmartList result2 = new SmartList();
        allReferencesMap.forEachEntry((arg_0, arg_1) -> ReferenceProvidersRegistryImpl.lambda$getLowerPriorityReferences$0(maxPriority, maxPriorityRefs, (List)result2, arg_0, arg_1));
        return result2;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<? extends PsiReference> higherPriorityRefs, PsiReference @NotNull [] lowerPriorityRefs) {
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference psiReference : higherPriorityRefs) {
                if (psiReference == null || !ReferenceRange.containsRangeInElement((PsiSymbolReference)psiReference, (TextRange)ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            return Collections.emptyList();
        }
        SmartList list2 = new SmartList();
        for (Object[] objectArray : references) {
            ContainerUtil.addAllNotNull((Collection)list2, (Object[])objectArray);
        }
        return list2;
    }

    @Deprecated
    public static void disableUnderlyingElementChecks(@NotNull Disposable parentDisposable) {
        Registry.get((String)"ide.check.reference.provider.underlying.element").setValue(false, parentDisposable);
    }

    private static /* synthetic */ boolean lambda$getLowerPriorityReferences$0(double maxPriority, List maxPriorityRefs, List result2, double priority, List referenceArrays) {
        if (maxPriority != priority) {
            for (Object[] references : referenceArrays) {
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges(maxPriorityRefs, (PsiReference[])references)) continue;
                ContainerUtil.addAllNotNull((Collection)result2, (Object[])references);
            }
        }
        return true;
    }
}

