/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PsiReferenceUtil {
    private PsiReferenceUtil() {
    }

    @Nullable
    public static <T extends PsiReference> T findReferenceOfClass(PsiReference ref, Class<T> clazz) {
        if (clazz.isInstance(ref)) {
            return (T)ref;
        }
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference2 : ((PsiMultiReference)ref).getReferences()) {
                if (!clazz.isInstance(reference2)) continue;
                return (T)reference2;
            }
        }
        return null;
    }

    @NotNull
    public static List<PsiReference> unwrapMultiReference(@NotNull PsiReference maybeMultiReference) {
        if (maybeMultiReference instanceof PsiMultiReference) {
            return ContainerUtil.immutableList((Object[])((PsiMultiReference)maybeMultiReference).getReferences());
        }
        return ContainerUtil.immutableSingletonList((Object)maybeMultiReference);
    }
}

