/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentCalculator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BaseLineOffsetCalculator myBaseLineOffsetCalculator;
    @NotNull
    private final Indent myIndent;
    public static final BaseLineOffsetCalculator LINE_BEFORE = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }
    };
    public static final BaseLineOffsetCalculator LINE_AFTER = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            return CharArrayUtil.shiftForward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }
    };

    public IndentCalculator(@NotNull Project project, @NotNull Editor editor, @NotNull BaseLineOffsetCalculator baseLineOffsetCalculator, @NotNull Indent indent) {
        this.myProject = project;
        this.myEditor = editor;
        this.myBaseLineOffsetCalculator = baseLineOffsetCalculator;
        this.myIndent = indent;
    }

    @Nullable
    String getIndentString(@Nullable Language language, @NotNull SemanticEditorPosition currPosition) {
        String baseIndent = this.getBaseIndent(currPosition);
        Document document = this.myEditor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 != null) {
            CommonCodeStyleSettings.IndentOptions options2;
            CommonCodeStyleSettings.IndentOptions fileOptions = CodeStyle.getIndentOptions((PsiFile)file2);
            CommonCodeStyleSettings.IndentOptions indentOptions = options2 = !fileOptions.isOverrideLanguageOptions() && language != null && !language.is(file2.getLanguage()) && !language.is(Language.ANY) ? CodeStyle.getLanguageSettings((PsiFile)file2, (Language)language).getIndentOptions() : fileOptions;
            if (options2 != null) {
                return baseIndent + new IndentInfo(0, IndentCalculator.indentToSize(this.myIndent, options2), 0, false).generateNewWhiteSpace(options2);
            }
        }
        return null;
    }

    @NotNull
    protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
        int indentEnd;
        int indentStart;
        int indentLineOffset;
        CharSequence docChars = this.myEditor.getDocument().getCharsSequence();
        int offset = currPosition.getStartOffset();
        if (offset > 0 && (indentLineOffset = this.myBaseLineOffsetCalculator.getOffsetInBaseIndentLine(currPosition)) > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)indentLineOffset, (String)"\n") + 1) >= 0 && (indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t")) > indentStart) {
            return docChars.subSequence(indentStart, indentEnd).toString();
        }
        return "";
    }

    private static int indentToSize(@NotNull Indent indent, @NotNull CommonCodeStyleSettings.IndentOptions options2) {
        if (indent.getType() == Indent.Type.NORMAL) {
            return options2.INDENT_SIZE;
        }
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return options2.CONTINUATION_INDENT_SIZE;
        }
        if (indent.getType() == Indent.Type.SPACES && indent instanceof IndentImpl) {
            return ((IndentImpl)indent).getSpaces();
        }
        return 0;
    }

    public static interface BaseLineOffsetCalculator {
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition var1);
    }
}

