/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.FormattingMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FormatterBasedIndentAdjuster {
    private static final int MAX_SYNCHRONOUS_ADJUSTMENT_DOC_SIZE = 100000;

    private FormatterBasedIndentAdjuster() {
    }

    public static void scheduleIndentAdjustment(@NotNull Project project, @NotNull Document document, int offset) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 != null) {
            IndentAdjusterRunnable fixer = new IndentAdjusterRunnable(project, document, file2, offset);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(document, file2)) {
                documentManager.commitDocument(document);
            }
            fixer.run();
        }
    }

    private static boolean isSynchronousAdjustment(@NotNull Document document, @NotNull PsiFile file2) {
        return ApplicationManager.getApplication().isUnitTestMode() || document.getTextLength() <= 100000 && !BlockSupport.isTooDeep((UserDataHolder)file2);
    }

    public static class IndentAdjusterRunnable
    implements Runnable {
        private final Project myProject;
        private final int myLine;
        private final Document myDocument;
        private final PsiFile myFile;

        public IndentAdjusterRunnable(@NotNull Project project, @NotNull Document document, @NotNull PsiFile file2, int offset) {
            this.myProject = project;
            this.myDocument = document;
            this.myLine = this.myDocument.getLineNumber(offset);
            this.myFile = file2;
        }

        @Override
        public void run() {
            int lineStart = this.myDocument.getLineStartOffset(this.myLine);
            int indentEnd = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)lineStart, (String)" \t");
            RangeMarker indentMarker = this.myDocument.createRangeMarker(lineStart, indentEnd);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
            if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(this.myDocument, this.myFile)) {
                this.updateIndent(indentMarker, codeStyleManager.getLineIndent(this.myFile, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER));
            } else {
                ReadAction.nonBlocking(() -> codeStyleManager.getLineIndent(this.myFile, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER)).withDocumentsCommitted(this.myProject).finishOnUiThread(ModalityState.NON_MODAL, indentString -> this.updateIndent(indentMarker, (String)indentString)).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        }

        private void updateIndent(@NotNull RangeMarker indentMarker, @Nullable String newIndent) {
            if (newIndent != null) {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myDocument.replaceString(indentMarker.getStartOffset(), indentMarker.getEndOffset(), (CharSequence)newIndent);
                    indentMarker.dispose();
                }));
            }
        }
    }
}

