/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FormattingRangesExtender {
    private static final Logger LOG = Logger.getInstance(FormattingRangesExtender.class);
    private static final int MAX_EXTENSION_LINES = 10;
    private final Document myDocument;
    private final PsiFile myFile;

    FormattingRangesExtender(@NotNull Document document, PsiFile file2) {
        this.myDocument = document;
        this.myFile = file2;
    }

    public List<TextRange> getExtendedRanges(@NotNull List<TextRange> ranges) {
        return ContainerUtil.map(ranges, range2 -> this.processRange((TextRange)range2));
    }

    private TextRange processRange(@NotNull TextRange originalRange) {
        TextRange validRange = this.ensureRangeIsValid(originalRange);
        ASTNode containingNode = CodeFormatterFacade.findContainingNode(this.myFile, this.expandToLine(validRange));
        if (containingNode != null && !validRange.isEmpty()) {
            return this.narrowToMaxExtensionLines(validRange, this.getRangeWithSiblings(containingNode));
        }
        return validRange;
    }

    private TextRange narrowToMaxExtensionLines(@NotNull TextRange original, @NotNull TextRange result2) {
        int startLine = Math.max(this.myDocument.getLineNumber(result2.getStartOffset()), this.myDocument.getLineNumber(original.getStartOffset()) - 10);
        int endLine = Math.min(this.myDocument.getLineNumber(result2.getEndOffset() - 1), this.myDocument.getLineNumber(original.getEndOffset() - 1) + 10);
        int rangeStart = Math.max(result2.getStartOffset(), this.myDocument.getLineStartOffset(startLine));
        int rangeEnd = Math.min(result2.getEndOffset(), this.myDocument.getLineEndOffset(endLine));
        return new TextRange(rangeStart, rangeEnd);
    }

    private TextRange ensureRangeIsValid(@NotNull TextRange range2) {
        int docLength;
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        if (endOffset > (docLength = this.myDocument.getTextLength())) {
            LOG.warn("The given range " + endOffset + " exceeds the document length " + docLength);
            return new TextRange(Math.min(startOffset, docLength), docLength);
        }
        return range2;
    }

    @Nullable
    private TextRange trimSpaces(@NotNull TextRange range2) {
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        startOffset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset, (String)" /t");
        if (startOffset == endOffset) {
            return null;
        }
        endOffset = CharArrayUtil.shiftBackward((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset, (String)" /t");
        return new TextRange(startOffset, endOffset);
    }

    private TextRange expandToLine(@NotNull TextRange range2) {
        int lineEnd;
        int lineStart;
        TextRange lineRange;
        int line = this.myDocument.getLineNumber(range2.getStartOffset());
        if (line == this.myDocument.getLineNumber(Math.min(range2.getEndOffset(), this.myDocument.getTextLength())) && (lineRange = this.trimSpaces(new TextRange(lineStart = this.myDocument.getLineStartOffset(line), lineEnd = this.myDocument.getLineEndOffset(line)))) != null) {
            return lineRange;
        }
        return range2;
    }

    @NotNull
    private TextRange getRangeWithSiblings(@NotNull ASTNode astNode) {
        ASTNode sibling;
        Ref result2 = Ref.create((Object)astNode.getTextRange());
        IElementType elementType = astNode.getElementType();
        for (sibling = astNode.getTreePrev(); sibling != null && FormattingRangesExtender.processSibling(sibling, (Ref<TextRange>)result2, elementType); sibling = sibling.getTreePrev()) {
        }
        for (sibling = astNode.getTreeNext(); sibling != null && FormattingRangesExtender.processSibling(sibling, (Ref<TextRange>)result2, elementType); sibling = sibling.getTreeNext()) {
        }
        assert (((TextRange)result2.get()).getEndOffset() <= this.myDocument.getTextLength()) : "PSI-document mismatch";
        return (TextRange)result2.get();
    }

    private static boolean processSibling(@NotNull ASTNode node, @NotNull Ref<TextRange> rangeRef, @NotNull IElementType siblingType) {
        if (node.getPsi() instanceof PsiWhiteSpace) {
            return !FormattingRangesExtender.hasMinLineBreaks(node, 2);
        }
        if (node.getElementType() == siblingType) {
            rangeRef.set((Object)((TextRange)rangeRef.get()).union(node.getTextRange()));
        }
        return false;
    }

    private static boolean hasMinLineBreaks(@NotNull ASTNode node, int lineBreaks) {
        int count = 0;
        for (int i2 = 0; i2 < node.getChars().length(); ++i2) {
            if (node.getChars().charAt(i2) == '\n') {
                ++count;
            }
            if (count < lineBreaks) continue;
            return true;
        }
        return false;
    }
}

