/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme,
SerializableScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private SchemeDataHolder<? super CodeStyleSchemeImpl> myDataHolder;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;
    private long myLastModificationCount;
    private final Object lock = new Object();

    CodeStyleSchemeImpl(@NotNull String name, String parentSchemeName, @NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder) {
        this.setName(name);
        this.myDataHolder = dataHolder;
        this.myIsDefault = "Default".equals(name);
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, @Nullable CodeStyleScheme parentScheme) {
        this.setName(name);
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    @NotNull
    private CodeStyleSettings init(@Nullable CodeStyleScheme parentScheme, @Nullable Element root) {
        CodeStyleSettings settings;
        if (parentScheme == null) {
            settings = CodeStyleSettingsManager.getInstance().createSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            settings = CodeStyleSettingsManager.getInstance().cloneSettings(parentSettings);
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            settings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                settings.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myCodeStyleSettings = settings;
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CodeStyleSettings getCodeStyleSettings() {
        CodeStyleSettings settings = this.myCodeStyleSettings;
        if (settings != null) {
            return settings;
        }
        Object object = this.lock;
        synchronized (object) {
            SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder = this.myDataHolder;
            if (dataHolder == null) {
                return this.myCodeStyleSettings;
            }
            Element element2 = dataHolder.read();
            this.myDataHolder = null;
            settings = this.init(this.myParentSchemeName == null ? null : CodeStyleSchemesImpl.getSchemeManager().findSchemeByName(this.myParentSchemeName), element2);
            dataHolder.updateDigest(this);
            this.myParentSchemeName = null;
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        this.myCodeStyleSettings = codeStyleSettings;
        Object object = this.lock;
        synchronized (object) {
            this.myParentSchemeName = null;
            this.myDataHolder = null;
        }
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SchemeState getSchemeState() {
        Object object = this.lock;
        synchronized (object) {
            long currModificationCount;
            if (this.myDataHolder == null && this.myLastModificationCount != (currModificationCount = this.myCodeStyleSettings.getModificationTracker().getModificationCount())) {
                this.myLastModificationCount = currModificationCount;
                return SchemeState.POSSIBLY_CHANGED;
            }
            return SchemeState.UNCHANGED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Element writeScheme() {
        SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder;
        Object object = this.lock;
        synchronized (object) {
            dataHolder = this.myDataHolder;
        }
        if (dataHolder == null) {
            Element newElement = new Element("code_scheme");
            newElement.setAttribute("name", this.getName());
            this.myCodeStyleSettings.writeExternal(newElement);
            return newElement;
        }
        return dataHolder.read();
    }
}

