/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatConstants;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.FormattingRangesExtender;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.TextRangeUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance(CodeFormatterFacade.class);
    private static final String WRAP_LINE_COMMAND_NAME = "AutoWrapLongLine";
    public static final Key<Boolean> WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY = new Key("WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY");
    private final CodeStyleSettings mySettings;
    private final FormatterTagHandler myTagHandler;
    private final int myRightMargin;
    private final boolean myCanChangeWhitespaceOnly;

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language) {
        this(settings, language, false);
    }

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language, boolean canChangeWhitespaceOnly) {
        this.mySettings = settings;
        this.myTagHandler = new FormatterTagHandler(settings);
        this.myRightMargin = this.mySettings.getRightMargin(language);
        this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
    }

    public ASTNode processElement(ASTNode element2) {
        TextRange range2 = element2.getTextRange();
        return this.processRange(element2, range2.getStartOffset(), range2.getEndOffset());
    }

    public ASTNode processRange(ASTNode element2, int startOffset, int endOffset) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element2);
        assert (psiElement != null);
        PsiFile file2 = psiElement.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        PsiElement elementToFormat = document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2) : psiElement;
        PsiFile fileToFormat = elementToFormat.getContainingFile();
        RangeMarker rangeMarker = null;
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)fileToFormat);
        if (builder2 != null) {
            if (document != null && endOffset < document.getTextLength()) {
                rangeMarker = document.createRangeMarker(startOffset, endOffset);
            }
            TextRange range2 = this.preprocess(element2, TextRange.create((int)startOffset, (int)endOffset));
            if (document instanceof DocumentWindow) {
                DocumentWindow documentWindow = (DocumentWindow)document;
                range2 = documentWindow.injectedToHost(range2);
            }
            FormattingModel model = CoreFormatterUtil.buildModel(builder2, elementToFormat, range2, this.mySettings, FormattingMode.REFORMAT);
            if (file2.getTextLength() > 0) {
                try {
                    FormatTextRanges ranges = new FormatTextRanges(range2, true);
                    this.setDisabledRanges(fileToFormat, ranges);
                    FormatterEx.getInstanceEx().format(model, this.mySettings, this.mySettings.getIndentOptionsByFile(fileToFormat, range2), ranges);
                    this.wrapLongLinesIfNecessary(file2, document, startOffset, endOffset);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (!psiElement.isValid()) {
                if (rangeMarker != null) {
                    PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
                    PsiElement result2 = PsiTreeUtil.getParentOfType((PsiElement)at, psiElement.getClass(), (boolean)false);
                    assert (result2 != null);
                    rangeMarker.dispose();
                    return result2.getNode();
                }
                assert (false);
            }
        }
        if (rangeMarker != null) {
            rangeMarker.dispose();
        }
        return element2;
    }

    public void processText(@NotNull PsiFile file2, FormatTextRanges ranges, boolean doPostponedFormatting) {
        FormattingModelBuilder builder2;
        Project project = file2.getProject();
        Document document = file2.getViewProvider().getDocument();
        List<FormatTextRange> textRanges = ranges.getRanges();
        if (document instanceof DocumentWindow) {
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
            DocumentWindow documentWindow = (DocumentWindow)document;
            for (FormatTextRange formatTextRange : textRanges) {
                formatTextRange.setTextRange(documentWindow.injectedToHost(formatTextRange.getTextRange()));
            }
            document = documentWindow.getDelegate();
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)file2)) != null && file2.getTextLength() > 0) {
            LOG.assertTrue(document != null);
            ranges.setExtendedRanges(new FormattingRangesExtender(document, file2).getExtendedRanges(ranges.getTextRanges()));
            try {
                ASTNode containingNode = CodeFormatterFacade.findContainingNode(file2, ranges.getBoundRange());
                if (containingNode != null) {
                    for (FormatTextRange range3 : ranges.getRanges()) {
                        TextRange rangeToUse = this.preprocess(containingNode, range3.getTextRange());
                        range3.setTextRange(rangeToUse);
                    }
                }
                if (doPostponedFormatting) {
                    CodeFormatterFacade.invokePostponedFormatting(file2, document, textRanges);
                }
                if (FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get().booleanValue()) {
                    return;
                }
                TextRange textRange = (TextRange)ObjectUtils.notNull((Object)ranges.getBoundRange(), (Object)file2.getTextRange());
                FormattingModel originalModel = CoreFormatterUtil.buildModel(builder2, (PsiElement)file2, textRange, this.mySettings, FormattingMode.REFORMAT);
                DocumentBasedFormattingModel model = new DocumentBasedFormattingModel(originalModel, document, project, this.mySettings, file2.getFileType(), file2);
                FormatterEx formatter = FormatterEx.getInstanceEx();
                if (CodeStyleManager.getInstance((Project)project).isSequentialProcessingAllowed()) {
                    formatter.setProgressTask(new FormattingProgressTask(project, file2, document));
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptionsByFile(file2, textRanges.size() == 1 ? textRanges.get(0).getTextRange() : null);
                this.setDisabledRanges(file2, ranges);
                formatter.format((FormattingModel)model, this.mySettings, indentOptions, ranges);
                for (FormatTextRange range4 : textRanges) {
                    TextRange textRange2 = range4.getTextRange();
                    this.wrapLongLinesIfNecessary(file2, document, textRange2.getStartOffset(), textRange2.getEndOffset());
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void setDisabledRanges(@NotNull PsiFile file2, FormatTextRanges ranges) {
        Iterable excludedRangesIterable = TextRangeUtil.excludeRanges((TextRange)file2.getTextRange(), this.myTagHandler.getEnabledRanges((ASTNode)file2.getNode(), file2.getTextRange()));
        ranges.setDisabledRanges((Collection)excludedRangesIterable);
    }

    private static void invokePostponedFormatting(@NotNull PsiFile file2, Document document, List<FormatTextRange> textRanges) {
        RangeMarker[] markers = new RangeMarker[textRanges.size()];
        int i2 = 0;
        for (FormatTextRange range2 : textRanges) {
            TextRange textRange = range2.getTextRange();
            int start2 = textRange.getStartOffset();
            int end = textRange.getEndOffset();
            if (start2 < 0 || end <= start2 || end > document.getTextLength()) continue;
            markers[i2] = document.createRangeMarker(textRange);
            markers[i2].setGreedyToLeft(true);
            markers[i2].setGreedyToRight(true);
            ++i2;
        }
        PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance(file2.getProject());
        FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
        component2.doPostponedFormatting(file2.getViewProvider());
        i2 = 0;
        for (FormatTextRange range3 : textRanges) {
            RangeMarker marker = markers[i2];
            if (marker != null) {
                range3.setTextRange(TextRange.create((Segment)marker));
                marker.dispose();
            }
            ++i2;
        }
    }

    @Nullable
    static ASTNode findContainingNode(@NotNull PsiFile file2, @Nullable TextRange range2) {
        Language language = file2.getLanguage();
        if (range2 == null) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement startElement = viewProvider.findElementAt(range2.getStartOffset(), language);
        PsiElement endElement = viewProvider.findElementAt(range2.getEndOffset() - 1, language);
        PsiElement commonParent = startElement != null && endElement != null ? PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement) : null;
        ASTNode node = null;
        if (commonParent != null) {
            node = commonParent.getNode();
            for (ASTNode parent = node.getTreeParent(); parent != null && parent.getTextRange().equals((Object)commonParent.getTextRange()); parent = parent.getTreeParent()) {
                node = parent;
            }
        }
        if (node == null) {
            node = file2.getNode();
        }
        return node;
    }

    private TextRange preprocess(@NotNull ASTNode node, @NotNull TextRange range2) {
        TextRange result2 = range2;
        PsiElement psi = node.getPsi();
        if (!psi.isValid()) {
            return result2;
        }
        PsiFile file2 = psi.getContainingFile();
        LinkedHashSet<TextRange> injectedFileRangesSet = new LinkedHashSet<TextRange>();
        if (!psi.getProject().isDefault()) {
            List injectedDocuments = InjectedLanguageManager.getInstance((Project)file2.getProject()).getCachedInjectedDocumentsInRange(file2, file2.getTextRange());
            if (!injectedDocuments.isEmpty()) {
                for (DocumentWindow injectedDocument : injectedDocuments) {
                    injectedFileRangesSet.add(TextRange.from((int)injectedDocument.injectedToHost(0), (int)injectedDocument.getTextLength()));
                }
            } else {
                Collection<PsiLanguageInjectionHost> injectionHosts = CodeFormatterFacade.collectInjectionHosts(file2, range2);
                PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
                    for (PsiLanguageInjectionHost.Shred place : places) {
                        Segment rangeMarker = place.getHostRangeMarker();
                        injectedFileRangesSet.add(TextRange.create((int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset()));
                    }
                };
                Iterator iterator2 = injectionHosts.iterator();
                while (iterator2.hasNext()) {
                    PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)iterator2.next();
                    InjectedLanguageManager.getInstance((Project)file2.getProject()).enumerate((PsiElement)host, visitor);
                }
            }
        }
        if (!injectedFileRangesSet.isEmpty()) {
            ArrayList ranges = new ArrayList(injectedFileRangesSet);
            Collections.reverse(ranges);
            for (TextRange injectedFileRange : ranges) {
                TextRange initialInjectedRange;
                PsiFile injected;
                int startHostOffset = injectedFileRange.getStartOffset();
                int endHostOffset = injectedFileRange.getEndOffset();
                if (startHostOffset < range2.getStartOffset() || endHostOffset > range2.getEndOffset() || (injected = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, startHostOffset)) == null) continue;
                TextRange injectedRange = initialInjectedRange = TextRange.create((int)0, (int)injected.getTextLength());
                for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                    if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                    injectedRange = processor2.process((ASTNode)injected.getNode(), injectedRange);
                }
                if ((initialInjectedRange.getStartOffset() <= injectedRange.getStartOffset() || initialInjectedRange.getStartOffset() <= 0) && (initialInjectedRange.getEndOffset() >= injectedRange.getEndOffset() || initialInjectedRange.getEndOffset() >= injected.getTextLength())) continue;
                range2 = TextRange.create((int)(range2.getStartOffset() + injectedRange.getStartOffset() - initialInjectedRange.getStartOffset()), (int)(range2.getEndOffset() + initialInjectedRange.getEndOffset() - injectedRange.getEndOffset()));
            }
        }
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            for (PreFormatProcessor processor3 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor3.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                result2 = processor3.process(node, result2);
            }
        } else {
            result2 = this.preprocessEnabledRanges(node, result2);
        }
        return result2;
    }

    private TextRange preprocessEnabledRanges(@NotNull ASTNode node, @NotNull TextRange range2) {
        TextRange result2 = TextRange.create((int)range2.getStartOffset(), (int)range2.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges(node, result2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                TextRange processedRange = processor2.process(node, enabledRange);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result2 = result2.grown(delta);
        return result2;
    }

    @NotNull
    private static Collection<PsiLanguageInjectionHost> collectInjectionHosts(@NotNull PsiFile file2, @NotNull TextRange range2) {
        Stack<PsiElement> toProcess2 = new Stack<PsiElement>();
        for (PsiElement e = file2.findElementAt(range2.getStartOffset()); e != null && e.getTextRange().getStartOffset() < range2.getEndOffset(); e = e.getNextSibling()) {
            toProcess2.push(e);
        }
        if (toProcess2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<PsiLanguageInjectionHost> result2 = null;
        while (!toProcess2.isEmpty()) {
            PsiElement e = (PsiElement)toProcess2.pop();
            if (e instanceof PsiLanguageInjectionHost) {
                if (result2 == null) {
                    result2 = new HashSet<PsiLanguageInjectionHost>();
                }
                result2.add((PsiLanguageInjectionHost)e);
                continue;
            }
            for (PsiElement child2 = e.getFirstChild(); child2 != null && e.getTextRange().getStartOffset() < range2.getEndOffset(); child2 = child2.getNextSibling()) {
                toProcess2.push(child2);
            }
        }
        return result2 == null ? Collections.emptySet() : result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapLongLinesIfNecessary(@NotNull PsiFile file2, @Nullable Document document, int startOffset, int endOffset) {
        if (!this.mySettings.getCommonSettings((Language)file2.getLanguage()).WRAP_LONG_LINES || PostprocessReformattingAspect.getInstance(file2.getProject()).isViewProviderLocked(file2.getViewProvider()) || document == null) {
            return;
        }
        FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyle.getSettings((PsiFile)file2));
        List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), new TextRange(startOffset, endOffset));
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        if ((vFile == null || vFile instanceof LightVirtualFile) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Editor editor = PsiEditorUtil.findEditor((PsiElement)file2);
        EditorFactory editorFactory = null;
        if (editor == null) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            editorFactory = EditorFactory.getInstance();
            editor = editorFactory.createEditor(document, file2.getProject(), file2.getVirtualFile(), false);
        }
        try {
            Editor editorToUse = editor;
            ApplicationManager.getApplication().runWriteAction(() -> {
                CaretModel caretModel = editorToUse.getCaretModel();
                int caretOffset = caretModel.getOffset();
                RangeMarker caretMarker = editorToUse.getDocument().createRangeMarker(caretOffset, caretOffset);
                this.doWrapLongLinesIfNecessary(editorToUse, file2.getProject(), editorToUse.getDocument(), startOffset, endOffset, enabledRanges);
                if (caretMarker.isValid() && caretModel.getOffset() != caretMarker.getStartOffset()) {
                    caretModel.moveToOffset(caretMarker.getStartOffset());
                }
            });
        }
        finally {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            if (documentManager.isUncommited(document)) {
                documentManager.commitDocument(document);
            }
            if (editorFactory != null) {
                editorFactory.releaseEditor(editor);
            }
        }
    }

    public void doWrapLongLinesIfNecessary(@NotNull Editor editor, @NotNull Project project, @NotNull Document document, int startOffset, int endOffset, List<? extends TextRange> enabledRanges) {
        int startOffsetToUse = MathUtil.clamp((int)startOffset, (int)0, (int)document.getTextLength());
        int endOffsetToUse = MathUtil.clamp((int)endOffset, (int)0, (int)document.getTextLength());
        LineWrapPositionStrategy strategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor(editor);
        CharSequence text = document.getCharsSequence();
        int startLine = document.getLineNumber(startOffsetToUse);
        int endLine = document.getLineNumber(Math.max(0, endOffsetToUse - 1));
        int maxLine = Math.min(document.getLineCount(), endLine + 1);
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        int[] shifts = new int[2];
        int cumulativeShift = 0;
        for (int line = startLine; line < maxLine; ++line) {
            int preferredWrapPosition;
            int startLineOffset = document.getLineStartOffset(line);
            int endLineOffset = document.getLineEndOffset(line);
            if (!CodeFormatterFacade.canWrapLine(Math.max(startOffsetToUse, startLineOffset), Math.min(endOffsetToUse, endLineOffset), cumulativeShift, enabledRanges) || (preferredWrapPosition = this.calculatePreferredWrapPosition(editor, text, tabSize, spaceSize, startLineOffset, endLineOffset, endOffsetToUse)) < 0 || preferredWrapPosition >= endLineOffset) continue;
            if (preferredWrapPosition >= endOffsetToUse) {
                return;
            }
            int wrapOffset = strategy.calculateWrapPosition(document, editor.getProject(), Math.max(startLineOffset, startOffsetToUse), Math.min(endLineOffset, endOffsetToUse), preferredWrapPosition, false, false);
            if (wrapOffset < 0 || CharArrayUtil.shiftBackward((CharSequence)text, (int)startLineOffset, (int)(wrapOffset - 1), (String)" \t") < startLineOffset) continue;
            editor.getCaretModel().moveToOffset(wrapOffset);
            CodeFormatterFacade.emulateEnter(editor, project, shifts);
            if (shifts[1] - 1 >= wrapOffset - startLineOffset) {
                document.deleteString(wrapOffset, wrapOffset + shifts[1]);
                continue;
            }
            maxLine += shifts[0];
            endOffsetToUse += shifts[1];
            cumulativeShift += shifts[1];
        }
    }

    private static boolean canWrapLine(int startOffset, int endOffset, int offsetShift, @NotNull List<? extends TextRange> enabledRanges) {
        for (TextRange textRange : enabledRanges) {
            if (!textRange.containsOffset(startOffset - offsetShift) || !textRange.containsOffset(endOffset - offsetShift)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emulateEnter(@NotNull Editor editor, @NotNull Project project, int[] shifts) {
        DataContext dataContext = CodeFormatterFacade.prepareContext(editor.getComponent(), project);
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int startSelectionOffset = 0;
        int endSelectionOffset = 0;
        boolean restoreSelection = selectionModel.hasSelection();
        if (restoreSelection) {
            startSelectionOffset = selectionModel.getSelectionStart();
            endSelectionOffset = selectionModel.getSelectionEnd();
            selectionModel.removeSelection();
        }
        int textLengthBeforeWrap = document.getTextLength();
        int lineCountBeforeWrap = document.getLineCount();
        DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, (Object)true);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            Runnable command = () -> EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            if (commandProcessor.getCurrentCommand() == null) {
                commandProcessor.executeCommand(editor.getProject(), command, WRAP_LINE_COMMAND_NAME, null);
            } else {
                command.run();
            }
        }
        finally {
            DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, null);
        }
        int symbolsDiff = document.getTextLength() - textLengthBeforeWrap;
        if (restoreSelection) {
            int newSelectionStart = startSelectionOffset;
            int newSelectionEnd = endSelectionOffset;
            if (startSelectionOffset >= caretOffset) {
                newSelectionStart += symbolsDiff;
            }
            if (endSelectionOffset >= caretOffset) {
                newSelectionEnd += symbolsDiff;
            }
            selectionModel.setSelection(newSelectionStart, newSelectionEnd);
        }
        shifts[0] = document.getLineCount() - lineCountBeforeWrap;
        shifts[1] = symbolsDiff;
    }

    private int calculatePreferredWrapPosition(@NotNull Editor editor, @NotNull CharSequence text, int tabSize, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset) {
        boolean hasTabs = false;
        boolean canOptimize = true;
        boolean hasNonSpaceSymbols = false;
        block4: for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            char c = text.charAt(i2);
            switch (c) {
                case '\t': {
                    hasTabs = true;
                    if (hasNonSpaceSymbols) {
                        canOptimize = false;
                        break block4;
                    }
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    hasNonSpaceSymbols = true;
                }
            }
        }
        int reservedWidthInColumns = FormatConstants.getReservedLineWrapWidthInColumns(editor);
        if (!hasTabs) {
            return this.wrapPositionForTextWithoutTabs(startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns);
        }
        if (canOptimize) {
            return this.wrapPositionForTabbedTextWithOptimization(text, tabSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns);
        }
        return this.wrapPositionForTabbedTextWithoutOptimization(editor, text, spaceSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns);
    }

    private int wrapPositionForTextWithoutTabs(int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns) {
        if (Math.min(endLineOffset, targetRangeEndOffset) - startLineOffset > this.myRightMargin) {
            return startLineOffset + this.myRightMargin - reservedWidthInColumns;
        }
        return -1;
    }

    private int wrapPositionForTabbedTextWithOptimization(@NotNull CharSequence text, int tabSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns) {
        int width = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            char c = text.charAt(i2);
            int n = symbolWidth = c == '\t' ? tabSize - width % tabSize : 1;
            if (width + symbolWidth + reservedWidthInColumns >= this.myRightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= reservedWidthInColumns) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= this.myRightMargin) {
                wrapLine = true;
                break;
            }
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    private int wrapPositionForTabbedTextWithoutOptimization(@NotNull Editor editor, @NotNull CharSequence text, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns) {
        int width = 0;
        int x = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            int newX;
            char c = text.charAt(i2);
            if (c == '\t') {
                newX = EditorUtil.nextTabStop(x, editor);
                int diffInPixels = newX - x;
                symbolWidth = diffInPixels / spaceSize;
                if (diffInPixels % spaceSize > 0) {
                    ++symbolWidth;
                }
            } else {
                newX = x + EditorUtil.charWidth(c, 0, editor);
                symbolWidth = 1;
            }
            if (width + symbolWidth + reservedWidthInColumns >= this.myRightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= reservedWidthInColumns) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= this.myRightMargin) {
                wrapLine = true;
                break;
            }
            x = newX;
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    @NotNull
    private static DataContext prepareContext(@NotNull Component component2, final @NotNull Project project) {
        final DataContext baseDataContext = DataManager.getInstance().getDataContext(component2);
        return new DelegatingDataContext(baseDataContext){

            @Override
            public Object getData(@NotNull @NonNls String dataId) {
                Object result2 = baseDataContext.getData(dataId);
                if (result2 == null && CommonDataKeys.PROJECT.is(dataId)) {
                    result2 = project;
                }
                return result2;
            }
        };
    }

    private static class DelegatingDataContext
    implements DataContext,
    UserDataHolder {
        private final DataContext myDataContextDelegate;
        private final UserDataHolder myDataHolderDelegate;

        DelegatingDataContext(DataContext delegate) {
            this.myDataContextDelegate = delegate;
            this.myDataHolderDelegate = delegate instanceof UserDataHolder ? (UserDataHolder)delegate : null;
        }

        public Object getData(@NotNull @NonNls String dataId) {
            return this.myDataContextDelegate.getData(dataId);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            return (T)(this.myDataHolderDelegate == null ? null : this.myDataHolderDelegate.getUserData(key));
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (this.myDataHolderDelegate != null) {
                this.myDataHolderDelegate.putUserData(key, value2);
            }
        }
    }
}

