/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.impl.source.codeStyle.FormattingRangesExtender;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class ChangedRangesUtil {
    @Contract(pure=true)
    private ChangedRangesUtil() {
    }

    @NotNull
    static List<TextRange> processChangedRanges(@NotNull PsiFile file2, @NotNull ChangedRangesInfo changedRangesInfo) {
        Document document = file2.getViewProvider().getDocument();
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (document != null) {
            FormattingRangesExtender extender = new FormattingRangesExtender(document, file2);
            for (TextRange range2 : changedRangesInfo.allChangedRanges) {
                List<TextRange> extended = extender.getExtendedRanges(Collections.singletonList(range2));
                result2.addAll(extended);
            }
        } else {
            result2.addAll(changedRangesInfo.allChangedRanges);
        }
        return ChangedRangesUtil.optimizedChangedRanges(result2);
    }

    @NotNull
    private static List<TextRange> optimizedChangedRanges(@NotNull List<TextRange> allChangedRanges) {
        if (allChangedRanges.isEmpty()) {
            return allChangedRanges;
        }
        List sorted = ContainerUtil.sorted(allChangedRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET);
        SmartList result2 = new SmartList();
        TextRange prev = (TextRange)sorted.get(0);
        for (TextRange next : sorted) {
            if (next.getStartOffset() <= prev.getEndOffset()) {
                int newEndOffset = Math.max(prev.getEndOffset(), next.getEndOffset());
                prev = new TextRange(prev.getStartOffset(), newEndOffset);
                continue;
            }
            result2.add(prev);
            prev = next;
        }
        result2.add(prev);
        return result2;
    }
}

