/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPointerTracker {
    private static final ReferenceQueue<SmartPsiElementPointerImpl<?>> ourQueue = new ReferenceQueue();
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized void addReference(@NotNull SmartPsiElementPointerImpl<?> pointer) {
        PointerReference reference2 = new PointerReference(pointer, this);
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
        }
        if (this.references[this.nextAvailableIndex] != null) {
            throw new AssertionError(this.references[this.nextAvailableIndex]);
        }
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference2);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index++, ref);
        }
        assert (index == this.size) : index + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index;
    }

    synchronized void removeReference(@NotNull PointerReference reference2) {
        int index = reference2.index;
        if (index < 0) {
            return;
        }
        if (this.references[index] != reference2) {
            throw new AssertionError((Object)("At " + index + " expected " + reference2 + ", found " + this.references[index]));
        }
        this.references[index].index = -1;
        this.references[index] = null;
        --this.size;
    }

    private void processAlivePointers(@NotNull Processor<? super SmartPsiElementPointerImpl<?>> processor2) {
        for (int i2 = 0; i2 < this.nextAvailableIndex; ++i2) {
            PointerReference ref = this.references[i2];
            if (ref == null) continue;
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref);
                continue;
            }
            if (processor2.process((Object)pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers2 = new ArrayList();
            this.processAlivePointers((Processor<? super SmartPsiElementPointerImpl<?>>)new CommonProcessors.CollectProcessor(pointers2));
            if (this.size != pointers2.size()) {
                throw new AssertionError();
            }
            pointers2.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i2 = 0; i2 < pointers2.size(); ++i2) {
                SmartPointerTracker.storePointerReference(this.references, i2, ((SmartPsiElementPointerImpl)pointers2.get((int)i2)).pointerReference);
            }
            Arrays.fill(this.references, pointers2.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers2.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        boolean stillSorted = this.markerCache.updateMarkers(frozen, events);
        if (!stillSorted) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument document, @NotNull List<? extends DocumentEvent> events) {
        return this.markerCache.getUpdatedRange(info, document, events);
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        return MarkerCache.getUpdatedRange(containingFile, segment, isSegmentGreedy, frozen, events);
    }

    synchronized void switchStubToAst(@NotNull AnchorElementInfo info, @NotNull PsiElement element2) {
        info.switchToTreeRange(element2);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts(@NotNull SmartPointerManagerImpl manager) {
        SmartPointerTracker.processQueue();
        this.processAlivePointers(pointer -> {
            pointer.getElementInfo().fastenBelt(manager);
            return true;
        });
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers(pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        E actual;
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null) {
            return;
        }
        boolean cachedValid = cachedElement.isValid();
        if (cachedValid) {
            if (pointerRange == null) {
                ((SelfElementInfo)pointer.getElementInfo()).switchToAnchor((PsiElement)cachedElement);
                return;
            }
            if (pointerRange.equals(cachedElement.getTextRange())) {
                return;
            }
        }
        if ((actual = pointer.doRestoreElement()) == null && cachedValid && ((SelfElementInfo)pointer.getElementInfo()).updateRangeToPsi(pointerRange, (PsiElement)cachedElement)) {
            return;
        }
        if (actual != cachedElement) {
            pointer.cacheElement(actual);
        }
    }

    private static void storePointerReference(PointerReference[] references, int index, PointerReference ref) {
        references[index] = ref;
        ref.index = index;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList<SelfElementInfo> infos = new ArrayList<SelfElementInfo>(this.size);
        this.processAlivePointers(pointer -> {
            SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
            if (!info.hasRange()) {
                return false;
            }
            infos.add(info);
            return true;
        });
        return infos;
    }

    synchronized int getSize() {
        return this.size;
    }

    static void processQueue() {
        PointerReference reference2;
        while ((reference2 = (PointerReference)ourQueue.poll()) != null) {
            if (reference2.get() != null) {
                throw new IllegalStateException("Queued reference has referent!");
            }
            reference2.tracker.removeReference(reference2);
        }
    }

    static {
        Application application = ApplicationManager.getApplication();
        if (!application.isDisposed()) {
            LowMemoryWatcher.register(() -> SmartPointerTracker.processQueue(), (Disposable)application);
        }
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl<?>> {
        @NotNull
        final SmartPointerTracker tracker;
        private int index = -2;

        private PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull SmartPointerTracker tracker) {
            super(pointer, ourQueue);
            this.tracker = tracker;
            pointer.pointerReference = this;
        }
    }
}

