/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myLanguageId;
    @NotNull
    private final String myFileClassName;

    FileElementInfo(@NotNull PsiFile file2) {
        this.myVirtualFile = file2.getViewProvider().getVirtualFile();
        this.myProject = file2.getProject();
        this.myLanguageId = LanguageUtil.getRootLanguage((PsiElement)file2).getID();
        this.myFileClassName = file2.getClass().getName();
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        Language language = Language.findLanguageByID((String)this.myLanguageId);
        if (language == null) {
            return null;
        }
        PsiFile file2 = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, language);
        return file2 != null && file2.getClass().getName().equals(this.myFileClassName) ? file2 : null;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        PsiElement element2 = this.restoreElement(manager);
        return element2 == null ? null : element2.getContainingFile();
    }

    @Override
    int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        return other instanceof FileElementInfo && Comparing.equal((Object)this.myVirtualFile, (Object)((FileElementInfo)other).myVirtualFile);
    }

    @Override
    @NotNull
    VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        return document == null ? null : TextRange.from((int)0, (int)document.getTextLength());
    }

    @Override
    @Nullable
    Segment getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        Document currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        DocumentEx committedDoc = currentDoc == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange(manager) : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguageId + "}";
    }
}

