/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class IndexPatternOccurrenceImpl
implements IndexPatternOccurrence {
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final IndexPattern myPattern;
    private final List<TextRange> myAdditionalRanges;

    IndexPatternOccurrenceImpl(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull IndexPattern pattern, @NotNull List<TextRange> additionalRanges) {
        this.myFile = file2;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPattern = pattern;
        this.myAdditionalRanges = additionalRanges;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public TextRange getTextRange() {
        return new TextRange(this.myStartOffset, this.myEndOffset);
    }

    @NotNull
    public List<TextRange> getAdditionalTextRanges() {
        return this.myAdditionalRanges;
    }

    @NotNull
    public IndexPattern getPattern() {
        return this.myPattern;
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myStartOffset + this.myEndOffset + this.myPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexPatternOccurrenceImpl)) {
            return false;
        }
        IndexPatternOccurrenceImpl todoItem = (IndexPatternOccurrenceImpl)obj;
        return this.myFile.equals(todoItem.myFile) && this.myStartOffset == todoItem.myStartOffset && this.myEndOffset == todoItem.myEndOffset && this.myPattern.equals((Object)todoItem.myPattern);
    }
}

