/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileIncludeManagerImpl
extends FileIncludeManager
implements Disposable {
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final PsiFileFactory myPsiFileFactory;
    private final IncludeCacheHolder myIncludedHolder = new IncludeCacheHolder("compile time includes", "runtime includes"){

        @Override
        protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
            THashSet files2 = new THashSet();
            FileIncludeManagerImpl.this.processIncludes(file2, (Processor<? super FileIncludeInfo>)((Processor)arg_0 -> this.lambda$computeFiles$0(compileTimeOnly, file2, (Set)files2, arg_0)));
            return VfsUtilCore.toVirtualFileArray((Collection)files2);
        }

        private /* synthetic */ boolean lambda$computeFiles$0(boolean compileTimeOnly, PsiFile file2, Set files2, FileIncludeInfo info) {
            PsiFileSystemItem item;
            if (compileTimeOnly != info.runtimeOnly && (item = FileIncludeManagerImpl.this.resolveFileInclude(info, file2)) != null) {
                ContainerUtil.addIfNotNull((Collection)files2, (Object)item.getVirtualFile());
            }
            return true;
        }
    };
    private final IncludeCacheHolder myIncludingHolder = new IncludeCacheHolder("compile time contexts", "runtime contexts"){

        @Override
        protected VirtualFile[] computeFiles(PsiFile context, boolean compileTimeOnly) {
            THashSet files2 = new THashSet();
            FileIncludeManagerImpl.this.processIncludingFiles(context, (Processor<? super Pair<VirtualFile, FileIncludeInfo>>)((Processor)arg_0 -> 2.lambda$computeFiles$0((Set)files2, arg_0)));
            return VfsUtilCore.toVirtualFileArray((Collection)files2);
        }

        private static /* synthetic */ boolean lambda$computeFiles$0(Set files2, Pair virtualFileFileIncludeInfoPair) {
            files2.add(virtualFileFileIncludeInfoPair.first);
            return true;
        }
    };
    private final Map<String, FileIncludeProvider> myProviderMap = new HashMap<String, FileIncludeProvider>();

    public void processIncludes(PsiFile file2, Processor<? super FileIncludeInfo> processor2) {
        List<FileIncludeInfo> infoList = FileIncludeIndex.getIncludes(file2.getVirtualFile(), this.myProject);
        for (FileIncludeInfo info : infoList) {
            if (processor2.process((Object)info)) continue;
            return;
        }
    }

    public void processIncludingFiles(PsiFile context, Processor<? super Pair<VirtualFile, FileIncludeInfo>> processor2) {
        VirtualFile contextFile = (context = context.getOriginalFile()).getVirtualFile();
        if (contextFile == null) {
            return;
        }
        String originalName = context.getName();
        Collection<String> names2 = FileIncludeManagerImpl.getPossibleIncludeNames(context, originalName);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        for (String name : names2) {
            MultiMap<VirtualFile, FileIncludeInfoImpl> infoList = FileIncludeIndex.getIncludingFileCandidates(name, scope);
            for (VirtualFile candidate : infoList.keySet()) {
                PsiFile psiFile = this.myPsiManager.findFile(candidate);
                if (psiFile == null || context.equals(psiFile)) continue;
                for (FileIncludeInfo info : infoList.get((Object)candidate)) {
                    PsiFileSystemItem item = this.resolveFileInclude(info, psiFile);
                    if (item == null || !contextFile.equals(item.getVirtualFile()) || processor2.process((Object)Pair.create((Object)candidate, (Object)info))) continue;
                    return;
                }
            }
        }
    }

    @NotNull
    private static Collection<String> getPossibleIncludeNames(@NotNull PsiFile context, @NotNull String originalName) {
        THashSet names2 = new THashSet();
        names2.add(originalName);
        for (FileIncludeProvider provider : (FileIncludeProvider[])FileIncludeProvider.EP_NAME.getExtensions()) {
            String newName = provider.getIncludeName(context, originalName);
            if (newName == originalName) continue;
            names2.add(newName);
        }
        return names2;
    }

    public FileIncludeManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myPsiFileFactory = PsiFileFactory.getInstance((Project)this.myProject);
        FileIncludeProvider.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileIncludeProvider>(){

            public void extensionAdded(@NotNull FileIncludeProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                FileIncludeProvider old = FileIncludeManagerImpl.this.myProviderMap.put(provider.getId(), provider);
                assert (old == null);
            }

            public void extensionRemoved(@NotNull FileIncludeProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                FileIncludeManagerImpl.this.myProviderMap.remove(provider.getId());
            }
        }, true, (Disposable)this);
    }

    public void dispose() {
    }

    public VirtualFile[] getIncludedFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
        return this.getIncludedFiles(file2, compileTimeOnly, false);
    }

    public VirtualFile[] getIncludedFiles(@NotNull VirtualFile file2, boolean compileTimeOnly, boolean recursively) {
        if (file2 instanceof VirtualFileWithId) {
            return this.myIncludedHolder.getAllFiles(file2, compileTimeOnly, recursively);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public VirtualFile[] getIncludingFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
        return this.myIncludingHolder.getAllFiles(file2, compileTimeOnly, false);
    }

    public PsiFileSystemItem resolveFileInclude(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        return this.doResolve(info, context);
    }

    @Nullable
    private PsiFileSystemItem doResolve(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info instanceof FileIncludeInfoImpl) {
            PsiFileSystemItem resolvedByProvider;
            String id2 = ((FileIncludeInfoImpl)info).providerId;
            FileIncludeProvider provider = id2 == null ? null : this.myProviderMap.get(id2);
            PsiFileSystemItem psiFileSystemItem = resolvedByProvider = provider == null ? null : provider.resolveIncludedFile(info, context);
            if (resolvedByProvider != null) {
                return resolvedByProvider;
            }
        }
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)info.path);
        psiFile.setOriginalFile(context);
        return new FileReferenceSet((PsiElement)psiFile){

            @Override
            protected boolean useIncludingFileAsContext() {
                return false;
            }
        }.resolve();
    }

    private static abstract class IncludedFilesProvider
    implements ParameterizedCachedValueProvider<VirtualFile[], PsiFile> {
        private final boolean myRuntimeOnly;

        IncludedFilesProvider(boolean runtimeOnly) {
            this.myRuntimeOnly = runtimeOnly;
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);

        public CachedValueProvider.Result<VirtualFile[]> compute(PsiFile psiFile) {
            VirtualFile[] value2 = this.computeFiles(psiFile, this.myRuntimeOnly);
            ArrayList<VirtualFile> deps = new ArrayList<VirtualFile>(Arrays.asList(value2));
            deps.add((VirtualFile)psiFile);
            deps.add((VirtualFile)VirtualFileManager.getInstance());
            return CachedValueProvider.Result.create((Object)value2, deps);
        }
    }

    private abstract class IncludeCacheHolder {
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> COMPILE_TIME_KEY;
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> RUNTIME_KEY;
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> COMPILE_TIME_PROVIDER = new IncludedFilesProvider(true){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file2, compileTimeOnly);
            }
        };
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> RUNTIME_PROVIDER = new IncludedFilesProvider(false){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file2, compileTimeOnly);
            }
        };

        private IncludeCacheHolder(String compileTimeKey, String runtimeKey) {
            this.COMPILE_TIME_KEY = Key.create((String)compileTimeKey);
            this.RUNTIME_KEY = Key.create((String)runtimeKey);
        }

        private VirtualFile @NotNull [] getAllFiles(@NotNull VirtualFile file2, boolean compileTimeOnly, boolean recursively) {
            if (recursively) {
                HashSet result2 = new HashSet();
                this.getAllFilesRecursively(file2, compileTimeOnly, result2);
                return VfsUtilCore.toVirtualFileArray(result2);
            }
            return this.getFiles(file2, compileTimeOnly);
        }

        private void getAllFilesRecursively(@NotNull VirtualFile file2, boolean compileTimeOnly, Set<? super VirtualFile> result2) {
            if (!result2.add((VirtualFile)file2)) {
                return;
            }
            VirtualFile[] includes = this.getFiles(file2, compileTimeOnly);
            if (includes.length != 0) {
                for (VirtualFile include : includes) {
                    this.getAllFilesRecursively(include, compileTimeOnly, result2);
                }
            }
        }

        private VirtualFile[] getFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
            PsiFile psiFile = FileIncludeManagerImpl.this.myPsiManager.findFile(file2);
            if (psiFile == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            if (compileTimeOnly) {
                return (VirtualFile[])CachedValuesManager.getManager((Project)FileIncludeManagerImpl.this.myProject).getParameterizedCachedValue((UserDataHolder)psiFile, this.COMPILE_TIME_KEY, this.COMPILE_TIME_PROVIDER, false, (Object)psiFile);
            }
            return (VirtualFile[])CachedValuesManager.getManager((Project)FileIncludeManagerImpl.this.myProject).getParameterizedCachedValue((UserDataHolder)psiFile, this.RUNTIME_KEY, this.RUNTIME_PROVIDER, false, (Object)psiFile);
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);
    }
}

