/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ide.scratch.ScratchFileHelper;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ResolveScopeManagerImpl
extends ResolveScopeManager {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<VirtualFile, GlobalSearchScope> myDefaultResolveScopesCache;
    private final AdditionalIndexableFileSet myAdditionalIndexableFileSet;

    public ResolveScopeManagerImpl(Project project) {
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myManager = PsiManager.getInstance((Project)project);
        this.myAdditionalIndexableFileSet = new AdditionalIndexableFileSet(project);
        this.myDefaultResolveScopesCache = ConcurrentFactoryMap.create(key -> {
            ResolveScopeProvider resolveScopeProvider;
            GlobalSearchScope scope = null;
            ResolveScopeEnlarger[] resolveScopeEnlargerArray = ResolveScopeProvider.EP_NAME.getExtensionList().iterator();
            while (resolveScopeEnlargerArray.hasNext() && (scope = (resolveScopeProvider = (ResolveScopeProvider)resolveScopeEnlargerArray.next()).getResolveScope((VirtualFile)key, this.myProject)) == null) {
            }
            if (scope == null) {
                scope = this.getInherentResolveScope((VirtualFile)key);
            }
            for (ResolveScopeEnlarger enlarger : (ResolveScopeEnlarger[])ResolveScopeEnlarger.EP_NAME.getExtensions()) {
                SearchScope extra = enlarger.getAdditionalResolveScope((VirtualFile)key, this.myProject);
                if (extra == null) continue;
                scope = scope.union(extra);
            }
            return scope;
        }, ContainerUtil::createConcurrentWeakKeySoftValueMap);
        ((PsiManagerImpl)this.myManager).registerRunnableToRunOnChange(this.myDefaultResolveScopesCache::clear);
        ResolveScopeProvider.EP_NAME.addChangeListener(() -> this.myDefaultResolveScopesCache.clear(), (Disposable)project);
        ResolveScopeEnlarger.EP_NAME.addChangeListener(() -> this.myDefaultResolveScopesCache.clear(), (Disposable)project);
    }

    private GlobalSearchScope getResolveScopeFromProviders(@NotNull VirtualFile vFile) {
        return this.myDefaultResolveScopesCache.get(vFile);
    }

    private GlobalSearchScope getInherentResolveScope(VirtualFile vFile) {
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean includeTests = TestSourcesFilter.isTestSources((VirtualFile)vFile, (Project)this.myProject);
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        }
        if (!projectFileIndex.isInLibrary(vFile)) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (!allScope.contains(vFile)) {
                return GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)vFile).uniteWith(allScope);
            }
            return allScope;
        }
        return LibraryScopeCache.getInstance(this.myProject).getLibraryScope(projectFileIndex.getOrderEntriesForFile(vFile));
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element2) {
        PsiElement context;
        GlobalSearchScope forcedScope;
        ProgressIndicatorProvider.checkCanceled();
        if (element2 instanceof PsiDirectory) {
            return this.getResolveScopeFromProviders(((PsiDirectory)element2).getVirtualFile());
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile instanceof PsiCodeFragment && (forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope()) != null) {
            return forcedScope;
        }
        if (containingFile != null && (context = containingFile.getContext()) != null) {
            return this.withFile(containingFile, this.getResolveScope(context));
        }
        if (containingFile == null) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = this.getPsiFileResolveScope(containingFile);
        ModelBranch branch = ModelBranch.getPsiBranch((PsiElement)containingFile);
        return branch != null ? ((ModelBranchImpl)branch).modifyScope(scope) : scope;
    }

    @NotNull
    private GlobalSearchScope getPsiFileResolveScope(@NotNull PsiFile psiFile) {
        if (psiFile instanceof FileResolveScopeProvider) {
            return ((FileResolveScopeProvider)psiFile).getFileResolveScope();
        }
        VirtualFile vFile = psiFile.getOriginalFile().getVirtualFile();
        if (vFile == null) {
            return this.withFile(psiFile, GlobalSearchScope.allScope((Project)this.myProject));
        }
        return this.getResolveScopeFromProviders(vFile);
    }

    private GlobalSearchScope withFile(PsiFile containingFile, GlobalSearchScope scope) {
        return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)containingFile) ? scope : scope.uniteWith(GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)containingFile.getViewProvider().getVirtualFile()));
    }

    @Override
    @NotNull
    public GlobalSearchScope getDefaultResolveScope(@NotNull VirtualFile vFile) {
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null) : "directory=" + vFile.isDirectory() + "; " + this.myProject;
        return this.getResolveScopeFromProviders(vFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element2) {
        PsiFile containingFile;
        VirtualFile virtualFile;
        VirtualFile vDirectory;
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element2 instanceof PsiDirectory) {
            vDirectory = ((PsiDirectory)element2).getVirtualFile();
            virtualFile = null;
            containingFile = null;
        } else {
            containingFile = element2.getContainingFile();
            if (containingFile == null) {
                return allScope;
            }
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return allScope;
            }
            if (virtualFile instanceof VirtualFileWindow) {
                return GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)((VirtualFileWindow)virtualFile).getDelegate());
            }
            if (ScratchFileHelper.isScratchFile((VirtualFile)virtualFile)) {
                return GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)virtualFile);
            }
            vDirectory = virtualFile.getParent();
        }
        if (vDirectory == null) {
            return allScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vDirectory);
        if (module == null) {
            VirtualFile notNullVFile = virtualFile != null ? virtualFile : vDirectory;
            List entries = projectFileIndex.getOrderEntriesForFile(notNullVFile);
            if (entries.isEmpty() && (this.myAdditionalIndexableFileSet.isInSet(notNullVFile) || this.isFromAdditionalLibraries(notNullVFile))) {
                return allScope;
            }
            GlobalSearchScope result2 = LibraryScopeCache.getInstance(this.myProject).getLibraryUseScope(entries);
            return containingFile == null || virtualFile.isDirectory() || result2.contains(virtualFile) ? result2 : GlobalSearchScope.fileScope((PsiFile)containingFile).uniteWith(result2);
        }
        boolean isTest = TestSourcesFilter.isTestSources((VirtualFile)vDirectory, (Project)this.myProject);
        return isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
    }

    private boolean isFromAdditionalLibraries(@NotNull VirtualFile file2) {
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(this.myProject)) {
                if (!library.contains(file2)) continue;
                return true;
            }
        }
        return false;
    }
}

