/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoIndexers
extends FileTypeExtension<DataIndexer<TodoIndexEntry, Integer, FileContent>> {
    public static final TodoIndexers INSTANCE = new TodoIndexers();
    private static final ExtensionPointName<ExtraPlaceChecker> EP_NAME = ExtensionPointName.create((String)"com.intellij.todoExtraPlaces");

    private TodoIndexers() {
        super("com.intellij.todoIndexer");
    }

    public static boolean needsTodoIndex(@NotNull VirtualFile file2) {
        if (FileBasedIndex.IGNORE_PLAIN_TEXT_FILES && file2.getFileType() == PlainTextFileType.INSTANCE) {
            return false;
        }
        for (ExtraPlaceChecker checker : EP_NAME.getExtensionList()) {
            if (!checker.accept(null, file2)) continue;
            return true;
        }
        return file2.isInLocalFileSystem() && TodoIndexers.isInContentOfAnyProject(file2);
    }

    public static boolean belongsToProject(@NotNull Project project, @NotNull VirtualFile file2) {
        for (ExtraPlaceChecker checker : EP_NAME.getExtensionList()) {
            if (!checker.accept(project, file2)) continue;
            return true;
        }
        return ProjectFileIndex.getInstance((Project)project).isInContent(file2);
    }

    private static boolean isInContentOfAnyProject(@NotNull VirtualFile file2) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDisposed() || !ProjectFileIndex.getInstance((Project)project).isInContent(file2)) continue;
            return true;
        }
        return false;
    }

    public static interface ExtraPlaceChecker {
        public boolean accept(@Nullable Project var1, @NotNull VirtualFile var2);
    }
}

