/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoIndex
extends FileBasedIndexExtension<TodoIndexEntry, Integer> {
    @NonNls
    public static final ID<TodoIndexEntry, Integer> NAME = ID.create((String)"TodoIndex");
    private final KeyDescriptor<TodoIndexEntry> myKeyDescriptor = new KeyDescriptor<TodoIndexEntry>(){

        public int getHashCode(TodoIndexEntry value2) {
            return value2.hashCode();
        }

        public boolean isEqual(TodoIndexEntry val1, TodoIndexEntry val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, TodoIndexEntry value2) throws IOException {
            out.writeUTF(value2.pattern);
            out.writeBoolean(value2.caseSensitive);
        }

        public TodoIndexEntry read(@NotNull DataInput in) throws IOException {
            String pattern = in.readUTF();
            boolean caseSensitive = in.readBoolean();
            return new TodoIndexEntry(pattern, caseSensitive);
        }
    };
    private final DataExternalizer<Integer> myValueExternalizer = new IntInlineKeyDescriptor(){

        protected boolean isCompactFormat() {
            return true;
        }
    };
    private final DataIndexer<TodoIndexEntry, Integer, FileContent> myIndexer = new CompositeDataIndexer<TodoIndexEntry, Integer, DataIndexer<TodoIndexEntry, Integer, FileContent>, String>(){

        @Nullable
        public DataIndexer<TodoIndexEntry, Integer, FileContent> calculateSubIndexer(@NotNull IndexedFile file2) {
            return PlatformIdTableBuilding.getTodoIndexer(file2.getFileType());
        }

        @NotNull
        public String getSubIndexerVersion(@NotNull DataIndexer<TodoIndexEntry, Integer, FileContent> indexer) {
            int version2 = indexer instanceof VersionedTodoIndexer ? ((VersionedTodoIndexer)indexer).getVersion() : 255;
            return indexer.getClass().getName() + ":" + version2;
        }

        @NotNull
        public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
            return EnumeratorStringDescriptor.INSTANCE;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData, @NotNull DataIndexer<TodoIndexEntry, Integer, FileContent> indexer) {
            return indexer.map((Object)inputData);
        }
    };

    public TodoIndex() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(IndexPatternProvider.INDEX_PATTERNS_CHANGED, (Object)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileBasedIndex.getInstance().requestRebuild(NAME);
            }
        });
    }

    public int getVersion() {
        return 11;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<TodoIndexEntry, Integer> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<TodoIndexEntry, Integer, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public KeyDescriptor<TodoIndexEntry> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file2 -> {
            if (!TodoIndexers.needsTodoIndex(file2)) {
                return false;
            }
            FileType fileType = file2.getFileType();
            if (fileType instanceof LanguageFileType) {
                return LanguageParserDefinitions.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage()) != null;
            }
            return PlatformIdTableBuilding.isTodoIndexerRegistered(fileType) || fileType instanceof CustomSyntaxTableFileType;
        };
    }

    public boolean hasSnapshotMapping() {
        return true;
    }
}

