/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.PlainTextIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PlainTextTodoIndexer
extends VersionedTodoIndexer {
    private static final Logger LOG = Logger.getInstance(PlainTextTodoIndexer.class);

    @NotNull
    public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
        IndexPattern[] indexPatterns = IndexPatternUtil.getIndexPatterns();
        if (indexPatterns.length <= 0) {
            return Collections.emptyMap();
        }
        String chars = inputData.getContentAsText().toString();
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
        for (IndexPattern indexPattern : indexPatterns) {
            if (!PlainTextTodoIndexer.idIndexContainAllWords(indexPattern.getWordsToFindFirst(), indexPattern.isCaseSensitive(), inputData)) continue;
            Pattern pattern = indexPattern.getOptimizedIndexingPattern();
            try {
                if (pattern == null) continue;
                Matcher matcher = pattern.matcher(StringPattern.newBombedCharSequence((CharSequence)chars));
                while (matcher.find()) {
                    if (matcher.start() == matcher.end()) continue;
                    occurrenceConsumer.incTodoOccurrence(indexPattern);
                }
            }
            catch (StackOverflowError error) {
                LOG.error((Throwable)error);
            }
        }
        HashMap<TodoIndexEntry, Integer> map2 = new HashMap<TodoIndexEntry, Integer>();
        for (IndexPattern indexPattern : indexPatterns) {
            int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            map2.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        return map2;
    }

    private static boolean idIndexContainAllWords(@NotNull List<String> words, boolean caseSensitive, @NotNull FileContent content2) {
        Map<IdIndexEntry, Integer> idIndexData = PlainTextIdIndexer.getIdIndexData(content2);
        return words.stream().allMatch(word -> idIndexData.containsKey(new IdIndexEntry((String)word, caseSensitive)));
    }
}

