/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IdIndexEntry {
    private final int myWordHashCode;

    public IdIndexEntry(@NotNull String word, boolean caseSensitive) {
        this(word, 0, word.length(), caseSensitive);
    }

    public IdIndexEntry(@NotNull CharSequence seq, int start2, int end, boolean caseSensitive) {
        this(IdIndexEntry.getWordHash(seq, start2, end, caseSensitive));
    }

    public IdIndexEntry(int wordHash) {
        this.myWordHashCode = wordHash;
    }

    public int getWordHashCode() {
        return this.myWordHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdIndexEntry that = (IdIndexEntry)o;
        return this.myWordHashCode == that.myWordHashCode;
    }

    public int hashCode() {
        return this.myWordHashCode;
    }

    public String toString() {
        return "IdIndexEntry[hash: " + this.myWordHashCode + "]";
    }

    static int getWordHash(@NotNull CharSequence line, int start2, int end, boolean caseSensitive) {
        if (start2 == end) {
            return 0;
        }
        char firstChar = line.charAt(start2);
        char lastChar = line.charAt(end - 1);
        if (!caseSensitive) {
            firstChar = StringUtil.toLowerCase((char)firstChar);
            lastChar = StringUtil.toLowerCase((char)lastChar);
        }
        return (firstChar << 8) + (lastChar << 4) + end - start2;
    }
}

