/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class IdIndexEntriesExternalizer
implements DataExternalizer<Collection<IdIndexEntry>> {
    private static final ThreadLocalCachedIntArray spareBufferLocal = new ThreadLocalCachedIntArray();

    IdIndexEntriesExternalizer() {
    }

    public void save(@NotNull DataOutput out, @NotNull Collection<IdIndexEntry> value2) throws IOException {
        int size = value2.size();
        int[] values2 = spareBufferLocal.getBuffer(size);
        int ptr = 0;
        for (IdIndexEntry ie : value2) {
            values2[ptr++] = ie.getWordHashCode();
        }
        Arrays.sort(values2, 0, size);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
        int prev = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            DataInputOutputUtil.writeLONG((DataOutput)out, (long)((long)values2[i2] - (long)prev));
            prev = values2[i2];
        }
    }

    public Collection<IdIndexEntry> read(@NotNull DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<IdIndexEntry> entries = new ArrayList<IdIndexEntry>(length);
        int prev = 0;
        while (length-- > 0) {
            int l = (int)(DataInputOutputUtil.readLONG((DataInput)in) + (long)prev);
            entries.add(new IdIndexEntry(l));
            prev = l;
        }
        return entries;
    }
}

