/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DocumentChangeDependentIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileTypeSpecificSubIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer>
implements DocumentChangeDependentIndex {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create((String)"IdIndex");
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };

    public int getVersion() {
        return 17;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        return new CompositeDataIndexer<IdIndexEntry, Integer, FileTypeSpecificSubIndexer<IdIndexer>, String>(){

            @Nullable
            public FileTypeSpecificSubIndexer<IdIndexer> calculateSubIndexer(@NotNull IndexedFile file2) {
                FileType type = file2.getFileType();
                IdIndexer indexer = IdTableBuilding.getFileTypeIndexer(type);
                return indexer == null ? null : new FileTypeSpecificSubIndexer((Object)indexer, file2.getFileType());
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) {
                return ((IdIndexer)indexer.getSubIndexerType()).getClass().getName() + ":" + ((IdIndexer)indexer.getSubIndexerType()).getVersion() + ":" + indexer.getFileType().getName();
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                return EnumeratorStringDescriptor.INSTANCE;
            }

            @NotNull
            public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData, @NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) {
                return ((IdIndexer)indexer.getSubIndexerType()).map(inputData);
            }
        };
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return new DataExternalizer<Integer>(){

            public void save(@NotNull DataOutput out, Integer value2) throws IOException {
                out.write((int)(value2 & 0xFF));
            }

            public Integer read(@NotNull DataInput in) throws IOException {
                return in.readByte() & 0xFF;
            }
        };
    }

    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file2 -> IdIndex.isIndexable(file2.getFileType());
    }

    public static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType && (fileType != PlainTextFileType.INSTANCE || !FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) || fileType instanceof CustomSyntaxTableFileType || IdTableBuilding.isIdIndexerRegistered(fileType) || CacheBuilderRegistry.getInstance().getCacheBuilder(fileType) != null;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }
}

