/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IdDataConsumer {
    @NotNull
    private final Map<IdIndexEntry, Integer> myResult = new THashMap();

    @NotNull
    public Map<IdIndexEntry, Integer> getResult() {
        return this.myResult;
    }

    public void addOccurrence(CharSequence charSequence, int start2, int end, int occurrenceMask) {
        if (end == start2) {
            return;
        }
        IdIndexEntry entry = new IdIndexEntry(charSequence, start2, end, true);
        this.addOccurrence(entry, occurrenceMask);
        int hashNoCase = IdIndexEntry.getWordHash(charSequence, start2, end, false);
        if (hashNoCase != entry.getWordHashCode()) {
            this.addOccurrence(new IdIndexEntry(hashNoCase), occurrenceMask);
        }
    }

    public void addOccurrence(char[] chars, int start2, int end, int occurrenceMask) {
        this.addOccurrence((CharSequence)new CharArrayCharSequence(chars), start2, end, occurrenceMask);
    }

    private void addOccurrence(@NotNull IdIndexEntry entry, int occurrenceMask) {
        int old;
        int v;
        if (occurrenceMask != 0 && (v = (old = this.myResult.getOrDefault(entry, 0).intValue()) | occurrenceMask) != old) {
            this.myResult.put(entry, v);
        }
    }
}

