/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValueBase;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PsiCachedValue<T>
extends CachedValueBase<T> {
    private static final Key<?> PSI_MOD_COUNT_OPTIMIZATION = Key.create((String)"PSI_MOD_COUNT_OPTIMIZATION");
    private final PsiManager myManager;

    PsiCachedValue(@NotNull PsiManager manager, boolean trackValue) {
        super(trackValue);
        this.myManager = manager;
    }

    @Override
    protected Object @NotNull [] normalizeDependencies(@NotNull CachedValueProvider.Result<T> result2) {
        Object[] dependencies = super.normalizeDependencies(result2);
        if (ContainerUtil.exists((Object[])dependencies, PsiCachedValue::isPsiModificationCount)) {
            for (Object dependency : dependencies) {
                ModelBranch branch;
                if (!(dependency instanceof PsiElement) || (branch = ModelBranch.getPsiBranch((PsiElement)((PsiElement)dependency))) == null) continue;
                return ArrayUtil.prepend(() -> branch.getBranchedPsiModificationCount(), (Object[])dependencies);
            }
        }
        if (dependencies.length == 1 && PsiCachedValue.isPsiModificationCount(dependencies[0])) {
            return dependencies;
        }
        if (dependencies.length > 0 && ContainerUtil.and((Object[])dependencies, this::anyChangeImpliesPsiCounterChange)) {
            return ArrayUtil.prepend(PSI_MOD_COUNT_OPTIMIZATION, (Object[])dependencies);
        }
        return dependencies;
    }

    private boolean anyChangeImpliesPsiCounterChange(@NotNull Object dependency) {
        return dependency instanceof PsiElement && this.isVeryPhysical((PsiElement)dependency) || dependency instanceof ProjectRootModificationTracker || PsiCachedValue.isPsiModificationCount(dependency);
    }

    private static boolean isPsiModificationCount(@NotNull Object dependency) {
        return dependency instanceof PsiModificationTracker || dependency == PsiModificationTracker.MODIFICATION_COUNT;
    }

    private boolean isVeryPhysical(@NotNull PsiElement dependency) {
        if (!dependency.isValid()) {
            return false;
        }
        if (!dependency.isPhysical()) {
            return false;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.myManager.getProject());
        PsiFile topLevelFile = manager.getTopLevelFile(dependency);
        return topLevelFile != null && topLevelFile.isPhysical();
    }

    @Override
    protected boolean isUpToDate(@NotNull CachedValueBase.Data data2) {
        if (this.myManager.isDisposed()) {
            return false;
        }
        Object[] dependencies = data2.getDependencies();
        if (dependencies.length > 0 && dependencies[0] == PSI_MOD_COUNT_OPTIMIZATION && data2.getTimeStamps()[0] == this.myManager.getModificationTracker().getModificationCount()) {
            return true;
        }
        return super.isUpToDate(data2);
    }

    @Override
    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == PSI_MOD_COUNT_OPTIMIZATION) {
            return false;
        }
        return super.isDependencyOutOfDate(dependency, oldTimeStamp);
    }

    @Override
    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency instanceof PsiDirectory) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        if (dependency instanceof PsiElement) {
            PsiElement element2 = (PsiElement)dependency;
            if (!element2.isValid()) {
                return -1L;
            }
            PsiFile containingFile = element2.getContainingFile();
            if (containingFile != null) {
                return containingFile.getModificationStamp();
            }
        }
        if (dependency == PsiModificationTracker.MODIFICATION_COUNT || dependency == PSI_MOD_COUNT_OPTIMIZATION) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        return super.getTimeStamp(dependency);
    }

    @Override
    public boolean isFromMyProject(@NotNull Project project) {
        return this.myManager.getProject() == project;
    }
}

