/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomDescriptionProvider;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultPomTargetDescriptionProvider
extends PomDescriptionProvider {
    public String getElementDescription(@NotNull PomTarget element2, @NotNull ElementDescriptionLocation location) {
        if (element2 instanceof PsiElement) {
            return null;
        }
        if (location == UsageViewTypeLocation.INSTANCE) {
            return DefaultPomTargetDescriptionProvider.getTypeName(element2);
        }
        if (location == UsageViewNodeTextLocation.INSTANCE) {
            return DefaultPomTargetDescriptionProvider.getTypeName(element2) + " " + StringUtil.notNullize((String)(element2 instanceof PomNamedTarget ? ((PomNamedTarget)element2).getName() : null), (String)"''");
        }
        if (location instanceof HighlightUsagesDescriptionLocation) {
            return DefaultPomTargetDescriptionProvider.getTypeName(element2);
        }
        return null;
    }

    private static String getTypeName(PomTarget element2) {
        TypePresentationService presentationService = TypePresentationService.getService();
        String elementTypeName = presentationService.getTypeName((Object)element2);
        if (elementTypeName != null) {
            return elementTypeName;
        }
        String classTypeName = presentationService.getTypePresentableName(element2.getClass());
        return classTypeName == null ? "Element" : classTypeName;
    }
}

