/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.statusbar;

import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.codeStyle.OtherFileTypesCodeStyleConfigurable;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarEditorBasedWidgetFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidget;
import com.intellij.ui.UIBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleStatusBarWidgetFactory
extends StatusBarEditorBasedWidgetFactory {
    @NotNull
    public String getId() {
        return CodeStyleStatusBarWidget.WIDGET_ID;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        return new CodeStyleStatusBarWidget(project);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return UIBundle.message((String)"status.bar.code.style.widget.name", (Object[])new Object[0]);
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        Disposer.dispose((Disposable)widget);
    }

    @NotNull
    public static DumbAwareAction createDefaultIndentConfigureAction(@NotNull PsiFile psiFile) {
        String langName = CodeStyleStatusBarWidgetFactory.getLangName(psiFile);
        return DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.widget.configure.indents", (Object[])new Object[]{langName}), event -> {
            Configurable configurable2 = CodeStyleStatusBarWidgetFactory.findCodeStyleConfigurableId(psiFile.getProject(), langName);
            if (configurable2 instanceof CodeStyleConfigurableWrapper) {
                ShowSettingsUtil.getInstance().editConfigurable(event.getProject(), configurable2, () -> ((CodeStyleConfigurableWrapper)configurable2).selectTab(ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0])));
            }
        });
    }

    @NotNull
    private static String getLangName(@NotNull PsiFile psiFile) {
        String name;
        Language language = psiFile.getLanguage();
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)language);
        if (provider != null && provider.getIndentOptionsEditor() != null && (name = provider.getConfigurableDisplayName()) != null) {
            return name;
        }
        return language.getDisplayName();
    }

    @Nullable
    private static Configurable findCodeStyleConfigurableId(@NotNull Project project, @NotNull String langName) {
        CodeStyleSchemesConfigurable topConfigurable = new CodeStyleSchemesConfigurable(project);
        SearchableConfigurable found = topConfigurable.findSubConfigurable(langName);
        return found != null ? found : topConfigurable.findSubConfigurable(OtherFileTypesCodeStyleConfigurable.getDisplayNameText());
    }
}

