/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.NewLineBlocksIterator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterBasedLineIndentInfoBuilder {
    private static final int MAX_NEW_LINE_BLOCKS_TO_PROCESS = 500;
    private final ProgressIndicator myProgressIndicator;
    private final Document myDocument;
    private final CharSequence myText;
    private final Block myRootBlock;

    public FormatterBasedLineIndentInfoBuilder(@NotNull Document document, @NotNull Block rootBlock, @Nullable ProgressIndicator indicator) {
        this.myDocument = document;
        this.myText = this.myDocument.getCharsSequence();
        this.myRootBlock = rootBlock;
        this.myProgressIndicator = indicator;
    }

    public List<LineIndentInfo> build() {
        List<Block> newLineBlocks = this.getBlocksStartingNewLine();
        return ContainerUtil.map(newLineBlocks, newLineBlock -> {
            int blockStartOffset = newLineBlock.getTextRange().getStartOffset();
            int line = this.myDocument.getLineNumber(blockStartOffset);
            int lineStartOffset = this.myDocument.getLineStartOffset(line);
            if (this.rangeHasTabs(lineStartOffset, blockStartOffset)) {
                return LineIndentInfo.LINE_WITH_TABS;
            }
            if (FormatterBasedLineIndentInfoBuilder.hasNormalIndent(newLineBlock)) {
                return LineIndentInfo.newNormalIndent(blockStartOffset - lineStartOffset);
            }
            return LineIndentInfo.LINE_WITH_NOT_COUNTABLE_INDENT;
        });
    }

    private static boolean hasNormalIndent(Block block) {
        int startOffset;
        TextRange range2 = block.getTextRange();
        List<Indent.Type> allIndents = FormatterBasedLineIndentInfoBuilder.getIndentOnStartOffset(block, range2, startOffset = range2.getStartOffset());
        if (FormatterBasedLineIndentInfoBuilder.hasOnlyNormalOrNoneIndents(allIndents)) {
            int normalIndents = ContainerUtil.filter(allIndents, type -> type == Indent.Type.NORMAL).size();
            return normalIndents < 2;
        }
        return false;
    }

    private static boolean hasOnlyNormalOrNoneIndents(List<Indent.Type> indents) {
        Indent.Type outerMostIndent = indents.get(0);
        if (outerMostIndent != Indent.Type.NONE && outerMostIndent != Indent.Type.NORMAL) {
            return false;
        }
        List<Indent.Type> innerIndents = indents.subList(1, indents.size());
        for (Indent.Type indent : innerIndents) {
            if (indent == Indent.Type.NONE || indent == Indent.Type.NORMAL || indent == Indent.Type.CONTINUATION_WITHOUT_FIRST) continue;
            return false;
        }
        return true;
    }

    private static List<Indent.Type> getIndentOnStartOffset(Block block, TextRange range2, int startOffset) {
        ArrayList<Indent.Type> indentsOnStartOffset = new ArrayList<Indent.Type>();
        while (block != null && range2.getStartOffset() == startOffset) {
            List subBlocks;
            Indent.Type type = block.getIndent() != null ? block.getIndent().getType() : Indent.Type.CONTINUATION_WITHOUT_FIRST;
            indentsOnStartOffset.add(type);
            if (block instanceof AbstractBlock) {
                ((AbstractBlock)block).setBuildIndentsOnly(true);
            }
            block = (subBlocks = block.getSubBlocks()).isEmpty() ? null : (Block)subBlocks.get(0);
        }
        return indentsOnStartOffset;
    }

    @NotNull
    private List<Block> getBlocksStartingNewLine() {
        NewLineBlocksIterator newLineBlocksIterator = new NewLineBlocksIterator(this.myRootBlock, this.myDocument, this.myProgressIndicator);
        ArrayList<Block> newLineBlocks = new ArrayList<Block>();
        int currentLine = 0;
        while (newLineBlocksIterator.hasNext() && currentLine < 500) {
            Block next = newLineBlocksIterator.next();
            if (next instanceof ASTBlock && ((ASTBlock)next).getNode() instanceof PsiComment) continue;
            newLineBlocks.add(next);
            ++currentLine;
        }
        return newLineBlocks;
    }

    private boolean rangeHasTabs(int lineStartOffset, int textStartOffset) {
        return CharArrayUtil.indexOf((CharSequence)this.myText, (CharSequence)"\t", (int)lineStartOffset, (int)textStartOffset) > 0;
    }
}

