/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class TimeStampedIndentOptions
extends CommonCodeStyleSettings.IndentOptions {
    private long myTimeStamp;
    private int myOriginalIndentOptionsHash;
    private boolean myDetected;

    protected TimeStampedIndentOptions(CommonCodeStyleSettings.IndentOptions toCopyFrom, long timeStamp) {
        this.copyFrom(toCopyFrom);
        this.myTimeStamp = timeStamp;
        this.myOriginalIndentOptionsHash = toCopyFrom.hashCode();
    }

    public void setDetected(boolean isDetected) {
        this.myDetected = isDetected;
    }

    void setTimeStamp(long timeStamp) {
        this.myTimeStamp = timeStamp;
    }

    public void setOriginalIndentOptionsHash(int originalIndentOptionsHash) {
        this.myOriginalIndentOptionsHash = originalIndentOptionsHash;
    }

    public boolean isOutdated(@NotNull Document document, @NotNull CommonCodeStyleSettings.IndentOptions defaultForFile) {
        return document.getModificationStamp() != this.myTimeStamp || defaultForFile.hashCode() != this.myOriginalIndentOptionsHash;
    }

    public boolean isDetected() {
        return this.myDetected;
    }
}

