/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ExternalFormatProcessor {
    public static final ExtensionPointName<ExternalFormatProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalFormatProcessor");

    public boolean activeForFile(@NotNull PsiFile var1);

    @Nullable
    public TextRange format(@NotNull PsiFile var1, @NotNull TextRange var2, boolean var3, boolean var4);

    @Nullable
    public String indent(@NotNull PsiFile var1, int var2);

    default public void createConfiguration(@NotNull Project project) {
    }

    @NonNls
    @NotNull
    public String getId();

    public static boolean useExternalFormatter(@NotNull PsiFile source) {
        return EP_NAME.getExtensionList().stream().anyMatch(efp -> efp.activeForFile(source));
    }

    @NotNull
    public static Optional<ExternalFormatProcessor> findExternalFormatter(@NonNls @NotNull String externalFormatterId) {
        return EP_NAME.getExtensionList().stream().filter(efp -> externalFormatterId.equals(efp.getId())).findFirst();
    }

    @Nullable
    public static ExternalFormatProcessor activeExternalFormatProcessor(@NotNull PsiFile source) {
        return EP_NAME.getExtensionList().stream().filter(efp -> efp.activeForFile(source)).findFirst().orElse(null);
    }

    @Nullable
    public static String indentLine(@NotNull PsiFile source, int lineStartOffset) {
        ExternalFormatProcessor efp = ExternalFormatProcessor.activeExternalFormatProcessor(source);
        return efp != null ? efp.indent(source, lineStartOffset) : null;
    }

    @Nullable
    public static TextRange formatRangeInFile(@NotNull PsiFile source, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks) {
        ExternalFormatProcessor efp = ExternalFormatProcessor.activeExternalFormatProcessor(source);
        return efp != null ? efp.format(source, range2, canChangeWhiteSpacesOnly, keepLineBreaks) : null;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement elementToFormat, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly) {
        TextRange rangeAfterFormat;
        PsiFile file2 = elementToFormat.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        if (document != null && (rangeAfterFormat = ExternalFormatProcessor.formatRangeInFile(file2, range2, canChangeWhiteSpacesOnly, false)) != null) {
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
            if (!elementToFormat.isValid()) {
                PsiElement elementAtStart = file2.findElementAt(rangeAfterFormat.getStartOffset());
                if (elementAtStart instanceof PsiWhiteSpace) {
                    elementAtStart = PsiTreeUtil.nextLeaf((PsiElement)elementAtStart);
                }
                if (elementAtStart != null) {
                    PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, elementToFormat.getClass());
                    if (parent != null) {
                        return parent;
                    }
                    return elementAtStart;
                }
            }
        }
        return elementToFormat;
    }
}

