/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CompositeSequentialTask;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.SequentialTaskWithFixedIterationsNumber;
import com.intellij.util.SequentialModalProgressTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsCodeFragmentFilter {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsCodeFragmentFilter.class);
    private final Project myProject;
    private final PsiFile myFile;
    private final Document myDocument;
    private final RangeMarker myTextRangeMarker;
    private final LanguageCodeStyleSettingsProvider myProvider;

    public CodeStyleSettingsCodeFragmentFilter(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull LanguageCodeStyleSettingsProvider settingsProvider) {
        this.myProvider = settingsProvider;
        this.myProject = file2.getProject();
        this.myFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("copy" + file2.getName(), file2.getLanguage(), (CharSequence)file2.getText(), true, false);
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        LOG.assertTrue(this.myDocument != null);
        this.myTextRangeMarker = this.myDocument.createRangeMarker(range2.getStartOffset(), range2.getEndOffset());
    }

    @NotNull
    public CodeStyleSettingsToShow getFieldNamesAffectingCodeFragment(LanguageCodeStyleSettingsProvider.SettingsType ... types) {
        Ref settingsToShow = new Ref();
        CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.getSettings((PsiFile)this.myFile), tempSettings -> settingsToShow.set((Object)this.computeFieldsWithTempSettings((CodeStyleSettings)tempSettings, types)));
        return (CodeStyleSettingsToShow)settingsToShow.get();
    }

    @NotNull
    private CodeStyleSettingsToShow computeFieldsWithTempSettings(CodeStyleSettings tempSettings, LanguageCodeStyleSettingsProvider.SettingsType[] types) {
        CommonCodeStyleSettings commonSettings = tempSettings.getCommonSettings(this.myProvider.getLanguage());
        CustomCodeStyleSettings customSettings = CodeStyleSettingsCodeFragmentFilter.getCustomSettings(this.myProvider, tempSettings);
        String title = CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.title", (Object[])new Object[0]);
        SequentialModalProgressTask progressTask2 = new SequentialModalProgressTask(this.myProject, StringUtil.capitalizeWords((String)title, (boolean)true));
        progressTask2.setCancelText(CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.cancel", (Object[])new Object[0]));
        CompositeSequentialTask compositeTask = new CompositeSequentialTask(progressTask2);
        compositeTask.setProgressText(CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.progress.text", (Object[])new Object[0]));
        compositeTask.setProgressText2(CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.progress.text.under", (Object[])new Object[0]));
        final HashMap<LanguageCodeStyleSettingsProvider.SettingsType, FilterFieldsTask> typeToTask = new HashMap<LanguageCodeStyleSettingsProvider.SettingsType, FilterFieldsTask>();
        for (LanguageCodeStyleSettingsProvider.SettingsType type : types) {
            Set fields2 = this.myProvider.getSupportedFields(type);
            FilterFieldsTask task2 = new FilterFieldsTask(commonSettings, customSettings, fields2);
            compositeTask.addTask(task2);
            typeToTask.put(type, task2);
        }
        Set otherFields = this.myProvider.getSupportedFields();
        final FilterFieldsTask otherFieldsTask = new FilterFieldsTask(commonSettings, customSettings, otherFields);
        if (!otherFields.isEmpty()) {
            compositeTask.addTask(otherFieldsTask);
        }
        progressTask2.setTask(compositeTask);
        progressTask2.setMinIterationTime(10L);
        ProgressManager.getInstance().run((Task)progressTask2);
        return new CodeStyleSettingsToShow(){

            @Override
            public List<String> getSettings(LanguageCodeStyleSettingsProvider.SettingsType type) {
                return ((FilterFieldsTask)typeToTask.get(type)).getAffectedFields();
            }

            @Override
            public List<String> getOtherSetting() {
                return new ArrayList<String>(otherFieldsTask.getAffectedFields());
            }
        };
    }

    @Nullable
    private static CustomCodeStyleSettings getCustomSettings(@NotNull LanguageCodeStyleSettingsProvider languageProvider, CodeStyleSettings tempSettings) {
        CustomCodeStyleSettings fromLanguageProvider = CodeStyleSettingsCodeFragmentFilter.getCustomSettingsFromProvider((CodeStyleSettingsProvider)languageProvider, tempSettings);
        if (fromLanguageProvider != null) {
            return fromLanguageProvider;
        }
        for (CodeStyleSettingsProvider codeStyleSettingsProvider : CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            CustomCodeStyleSettings settings;
            if (!languageProvider.getLanguage().equals(codeStyleSettingsProvider.getLanguage()) || (settings = CodeStyleSettingsCodeFragmentFilter.getCustomSettingsFromProvider(codeStyleSettingsProvider, tempSettings)) == null) continue;
            return settings;
        }
        return null;
    }

    @Nullable
    private static CustomCodeStyleSettings getCustomSettingsFromProvider(@NotNull CodeStyleSettingsProvider languageProvider, CodeStyleSettings tempSettings) {
        CustomCodeStyleSettings modelSettings = languageProvider.createCustomSettings(tempSettings);
        return modelSettings != null ? tempSettings.getCustomSettings(modelSettings.getClass()) : null;
    }

    private boolean formattingChangedFragment() {
        CharSequence fragmentAfter;
        int rangeStart = this.myTextRangeMarker.getStartOffset();
        int rangeEnd = this.myTextRangeMarker.getEndOffset();
        CharSequence textBefore = this.myDocument.getCharsSequence();
        ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)this.myProject).reformatText(this.myFile, rangeStart, rangeEnd));
        if (rangeStart != this.myTextRangeMarker.getStartOffset() || rangeEnd != this.myTextRangeMarker.getEndOffset()) {
            return true;
        }
        CharSequence fragmentBefore = textBefore.subSequence(rangeStart, rangeEnd);
        return !StringUtil.equals((CharSequence)fragmentBefore, (CharSequence)(fragmentAfter = this.myDocument.getCharsSequence().subSequence(rangeStart, rangeEnd)));
    }

    public static interface CodeStyleSettingsToShow {
        public List<String> getSettings(LanguageCodeStyleSettingsProvider.SettingsType var1);

        public List<String> getOtherSetting();
    }

    private class FilterFieldsTask
    implements SequentialTaskWithFixedIterationsNumber {
        private final Iterator<String> myIterator;
        private final int myTotalFieldsNumber;
        private final Collection<String> myAllFields;
        private List<String> myAffectingFields = new ArrayList<String>();
        private final Object myCommonSettings;
        @Nullable
        private final CustomCodeStyleSettings myCustomSettings;

        FilterFieldsTask(@Nullable CommonCodeStyleSettings commonSettings, @NotNull CustomCodeStyleSettings customSettings, Collection<String> fields2) {
            this.myCustomSettings = customSettings;
            this.myAllFields = fields2;
            this.myIterator = fields2.iterator();
            this.myCommonSettings = commonSettings;
            this.myTotalFieldsNumber = fields2.size();
        }

        public List<String> getAffectedFields() {
            return this.myAffectingFields;
        }

        @Override
        public int getTotalIterationsNumber() {
            return this.myTotalFieldsNumber;
        }

        public void stop() {
            if (!this.isDone()) {
                this.myAffectingFields = new ArrayList<String>(this.myAllFields);
            }
        }

        public boolean isDone() {
            return !this.myIterator.hasNext();
        }

        public boolean iteration() {
            if (!this.myIterator.hasNext()) {
                return true;
            }
            String field = this.myIterator.next();
            if (this.myCustomSettings != null) {
                this.checkFieldAffectsSettings(this.myCustomSettings, field);
            }
            this.checkFieldAffectsSettings(this.myCommonSettings, field);
            return true;
        }

        private void checkFieldAffectsSettings(@NotNull Object settings, String field) {
            try {
                Field classField = settings.getClass().getField(field);
                if (classField.getType() == Integer.TYPE) {
                    int oldValue = classField.getInt(settings);
                    int newValue2 = this.getNewIntValue(classField, oldValue);
                    if (newValue2 == oldValue) {
                        return;
                    }
                    classField.set(settings, newValue2);
                } else if (classField.getType() == Boolean.TYPE) {
                    boolean value2 = classField.getBoolean(settings);
                    classField.set(settings, !value2);
                } else {
                    return;
                }
                if (CodeStyleSettingsCodeFragmentFilter.this.formattingChangedFragment()) {
                    this.myAffectingFields.add(field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getNewIntValue(Field classField, int oldValue) {
            String fieldName = classField.getName();
            if (fieldName.contains("WRAP")) {
                return oldValue == 2 ? 0 : 2;
            }
            if (fieldName.contains("BRACE_FORCE")) {
                return oldValue == 3 ? 0 : 1;
            }
            if (fieldName.contains("BRACE_STYLE")) {
                return oldValue == 1 ? 4 : 1;
            }
            return oldValue;
        }
    }
}

