/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceProviderType {
    @NonNls
    public static final String EP_NAME = "com.intellij.referenceProviderType";
    private static final KeyedExtensionCollector<PsiReferenceProvider, ReferenceProviderType> COLLECTOR = new KeyedExtensionCollector<PsiReferenceProvider, ReferenceProviderType>("com.intellij.referenceProviderType"){

        @NotNull
        protected String keyToString(@NotNull ReferenceProviderType key) {
            return key.myId;
        }
    };
    private final String myId;

    public ReferenceProviderType(@NonNls @NotNull String id2) {
        this.myId = id2;
    }

    @NotNull
    public PsiReferenceProvider getProvider() {
        return new CompositePsiReferenceProvider(this);
    }

    public String toString() {
        return this.myId;
    }

    private static class CompositePsiReferenceProvider
    extends PsiReferenceProvider
    implements CustomizableReferenceProvider {
        private final ReferenceProviderType myType;

        private CompositePsiReferenceProvider(ReferenceProviderType type) {
            this.myType = type;
        }

        @Override
        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
            ArrayList result2 = new ArrayList();
            for (PsiReferenceProvider child2 : COLLECTOR.forKey((Object)this.myType)) {
                ContainerUtil.addAllNotNull(result2, (Object[])child2.getReferencesByElement(element2, context));
            }
            return result2.toArray(PsiReference.EMPTY_ARRAY);
        }

        public boolean acceptsTarget(@NotNull PsiElement target2) {
            for (PsiReferenceProvider child2 : COLLECTOR.forKey((Object)this.myType)) {
                if (!child2.acceptsTarget(target2)) continue;
                return true;
            }
            return false;
        }

        public boolean acceptsHints(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints2) {
            for (PsiReferenceProvider child2 : COLLECTOR.forKey((Object)this.myType)) {
                if (!child2.acceptsHints(element2, hints2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options2) {
            throw new UnsupportedOperationException("Modifying shared reference provider is not supported");
        }

        @Override
        @Nullable
        public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
            for (PsiReferenceProvider provider : COLLECTOR.forKey((Object)this.myType)) {
                if (!(provider instanceof CustomizableReferenceProvider)) continue;
                return ((CustomizableReferenceProvider)provider).getOptions();
            }
            return Collections.emptyMap();
        }
    }
}

