/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceServiceImpl
extends PsiReferenceService {
    private static final Logger LOG = Logger.getInstance(PsiReferenceService.class);
    private static final Set<String> ourReportedReferenceClasses = ContainerUtil.newConcurrentSet();

    @NotNull
    public List<PsiReference> getReferences(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints2) {
        List<PsiReference> references = PsiReferenceServiceImpl.doGetReferences(element2, hints2);
        PsiReferenceServiceImpl.assertReferencesHaveSameElement(element2, references);
        return references;
    }

    @NotNull
    private static List<PsiReference> doGetReferences(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints2) {
        if (element2 instanceof ContributedReferenceHost) {
            return Arrays.asList(ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)element2, (PsiReferenceService.Hints)hints2));
        }
        if (element2 instanceof HintedReferenceHost) {
            return Arrays.asList(((HintedReferenceHost)element2).getReferences(hints2));
        }
        return Arrays.asList(element2.getReferences());
    }

    private static void assertReferencesHaveSameElement(@NotNull PsiElement element2, @NotNull List<PsiReference> references) {
        for (PsiReference reference2 : references) {
            PsiElement referenceElement = reference2.getElement();
            if (referenceElement == element2 || !ourReportedReferenceClasses.add(reference2.getClass().getName())) continue;
            LOG.error("Reference element is not the same element for which references were queried", (Throwable)new RuntimeException("Element: " + element2.getClass().getName() + "; reference: " + reference2.getClass().getName() + "; reference element: " + referenceElement.getClass().getName()), new Attachment[]{new Attachment("info.txt", "Element text: `" + element2.getText() + "`\nReference range: " + reference2.getRangeInElement())});
        }
    }
}

