/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JTable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SeverityRenderer
extends ComboBoxTableRenderer<HighlightSeverity> {
    private static final Icon DEFAULT_DISABLED_ICON = HighlightDisplayLevel.createIconByMask((Color)UIUtil.getLabelDisabledForeground());
    static final HighlightSeverity EDIT_SEVERITIES = new HighlightSeverity(InspectionsBundle.message((String)"inspection.edit.severities.text", (Object[])new Object[0]), -1);
    @NotNull
    private final Runnable myOnClose;
    private final ScopesAndSeveritiesTable myTable;
    @NotNull
    private final Project myProject;

    public SeverityRenderer(@NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project, @NotNull Runnable onClose2, @NotNull ScopesAndSeveritiesTable table) {
        super((Object[])SeverityRenderer.getSeverities(inspectionProfile));
        this.myOnClose = onClose2;
        this.myTable = table;
        this.myProject = project;
    }

    public static HighlightSeverity @NotNull [] getSeverities(InspectionProfileImpl inspectionProfile) {
        Stream severities = LevelChooserAction.getSeverities(inspectionProfile.getProfileManager().getSeverityRegistrar()).stream();
        return (HighlightSeverity[])StreamEx.of(severities).append((Object)EDIT_SEVERITIES).toArray(HighlightSeverity.class);
    }

    public static Icon getIcon(@NotNull HighlightDisplayLevel level) {
        Icon icon2 = level.getIcon();
        return icon2 instanceof HighlightDisplayLevel.ColoredIcon ? new ColorIcon(icon2.getIconWidth(), ((HighlightDisplayLevel.ColoredIcon)icon2).getColor()) : icon2;
    }

    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        component2.setEnabled(((ScopesAndSeveritiesTable)((Object)table)).isRowEnabled(row));
        return component2;
    }

    protected void customizeComponent(HighlightSeverity value2, JTable table, boolean isSelected) {
        super.customizeComponent((Object)value2, table, isSelected);
        HighlightDisplayLevel hdl = HighlightDisplayLevel.find((HighlightSeverity)value2);
        this.setDisabledIcon(hdl != null ? IconLoader.getDisabledIcon((Icon)hdl.getIcon()) : DEFAULT_DISABLED_ICON);
    }

    protected String getTextFor(@NotNull HighlightSeverity value2) {
        return SingleInspectionProfilePanel.renderSeverity(value2);
    }

    protected Icon getIconFor(@NotNull HighlightSeverity value2) {
        return value2 == EDIT_SEVERITIES ? EmptyIcon.create((int)HighlightDisplayLevel.getEmptyIconDim()) : HighlightDisplayLevel.find((HighlightSeverity)value2).getIcon();
    }

    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
    }

    protected ListSeparator getSeparatorAbove(HighlightSeverity value2) {
        return value2 == EDIT_SEVERITIES ? new ListSeparator() : null;
    }

    public void onClosed(@NotNull LightweightWindowEvent event) {
        super.onClosed(event);
        this.myOnClose.run();
        if (this.getCellEditorValue() == EDIT_SEVERITIES) {
            ApplicationManager.getApplication().invokeLater(() -> SeverityEditorDialog.show(this.myProject, null, SeverityRegistrar.getSeverityRegistrar(this.myProject), true, (Consumer<? super HighlightSeverity>)((Consumer)severity -> this.myTable.setSelectedSeverity((HighlightSeverity)severity))));
        }
    }
}

