/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.table.SeverityRenderer;
import com.intellij.profile.codeInspection.ui.table.ThreeStateCheckBoxRenderer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopesAndSeveritiesTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance(ScopesAndSeveritiesTable.class);
    public static final HighlightSeverity MIXED_FAKE_SEVERITY = new HighlightSeverity("Mixed", -1);
    public static final HighlightDisplayLevel MIXED_FAKE_LEVEL = new HighlightDisplayLevel(MIXED_FAKE_SEVERITY, AllIcons.General.InspectionsMixed);
    private static final int SCOPE_ENABLED_COLUMN = 0;
    private static final int SCOPE_NAME_COLUMN = 1;
    private static final int SEVERITY_COLUMN = 2;

    public ScopesAndSeveritiesTable(final TableSettings tableSettings) {
        super((TableModel)new MyTableModel(tableSettings));
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn scopeEnabledColumn = columnModel.getColumn(0);
        scopeEnabledColumn.setMaxWidth(30);
        scopeEnabledColumn.setCellRenderer(new ThreeStateCheckBoxRenderer());
        scopeEnabledColumn.setCellEditor(new ThreeStateCheckBoxRenderer());
        TableColumn severityColumn = columnModel.getColumn(2);
        SeverityRenderer renderer = new SeverityRenderer(tableSettings.getInspectionProfile(), tableSettings.getProject(), () -> tableSettings.onSettingsChanged(), this);
        severityColumn.setCellRenderer((TableCellRenderer)((Object)renderer));
        severityColumn.setCellEditor((TableCellEditor)((Object)renderer));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExistedScopesStatesAndNonExistNames scopeToolState;
                List<ScopeToolState> existedStates;
                int idx = ScopesAndSeveritiesTable.this.getSelectionModel().getMinSelectionIndex();
                if (idx >= 0 && (existedStates = (scopeToolState = ((MyTableModel)ScopesAndSeveritiesTable.this.getModel()).getScopeToolState(idx)).getExistedStates()).size() == 1 && scopeToolState.getNonExistNames().isEmpty()) {
                    tableSettings.onScopeChosen(existedStates.get(0));
                }
            }
        });
        this.setRowSelectionInterval(0, 0);
        this.setStriped(true);
        this.setShowGrid(false);
        ((MyTableModel)this.getModel()).setTable(this);
    }

    boolean isRowEnabled(int row) {
        return Boolean.TRUE.equals(((MyTableModel)this.getModel()).isEnabled(row));
    }

    void setSelectedSeverity(HighlightSeverity severity) {
        this.getModel().setValueAt(severity, this.getSelectedRow(), 2);
    }

    public List<ScopeToolState> getSelectedStates() {
        return ((MyTableModel)this.getModel()).getScopeToolState(this.getSelectedRow()).getExistedStates();
    }

    @NotNull
    public static HighlightSeverity getSeverity(List<? extends ScopeToolState> scopeToolStates) {
        HighlightSeverity previousValue2 = null;
        for (ScopeToolState scopeToolState : scopeToolStates) {
            HighlightSeverity currentValue = scopeToolState.getLevel().getSeverity();
            if (previousValue2 == null) {
                previousValue2 = currentValue;
                continue;
            }
            if (previousValue2.equals((Object)currentValue)) continue;
            return MIXED_FAKE_SEVERITY;
        }
        return previousValue2;
    }

    private static class ExistedScopesStatesAndNonExistNames {
        private final List<ScopeToolState> myExistedStates;
        private final List<String> myNonExistNames;

        ExistedScopesStatesAndNonExistNames(List<ScopeToolState> existedStates, List<String> nonExistNames) {
            this.myExistedStates = existedStates;
            this.myNonExistNames = nonExistNames;
        }

        public List<ScopeToolState> getExistedStates() {
            return this.myExistedStates;
        }

        public List<String> getNonExistNames() {
            return this.myNonExistNames;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        @NotNull
        private final InspectionProfileImpl myInspectionProfile;
        private final List<String> myKeyNames;
        @NotNull
        private final Project myProject;
        private final TableSettings myTableSettings;
        private final List<HighlightDisplayKey> myKeys;
        private final Comparator<String> myScopeComparator;
        private ScopesAndSeveritiesTable myTable;
        private String[] myScopeNames;

        MyTableModel(@NotNull TableSettings tableSettings) {
            this.myTableSettings = tableSettings;
            this.myProject = tableSettings.getProject();
            this.myInspectionProfile = tableSettings.getInspectionProfile();
            this.myKeys = tableSettings.getKeys();
            this.myKeyNames = tableSettings.getKeyNames();
            this.myScopeComparator = new ScopeOrderComparator(this.myInspectionProfile);
            this.refreshAggregatedScopes();
        }

        public void setTable(ScopesAndSeveritiesTable table) {
            this.myTable = table;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return false;
            }
            if (columnIndex == 0) {
                return true;
            }
            assert (columnIndex == 2);
            if (Boolean.FALSE.equals(this.isEnabled(rowIndex))) {
                return false;
            }
            ExistedScopesStatesAndNonExistNames scopeToolState = this.getScopeToolState(rowIndex);
            return scopeToolState.getNonExistNames().isEmpty();
        }

        @Override
        public int getRowCount() {
            return this.lastRowIndex() + 1;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (0 == columnIndex) {
                return Boolean.class;
            }
            if (1 == columnIndex) {
                return String.class;
            }
            if (2 == columnIndex) {
                return HighlightSeverity.class;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.isEnabled(rowIndex);
                }
                case 1: {
                    return rowIndex == this.lastRowIndex() ? "Everywhere else" : this.getScopeName(rowIndex);
                }
                case 2: {
                    return this.getSeverityState(rowIndex);
                }
            }
            throw new IllegalArgumentException("Invalid column index " + columnIndex);
        }

        private NamedScope getScope(int rowIndex) {
            return this.getScopeToolState(rowIndex).getExistedStates().get(0).getScope(this.myProject);
        }

        private String getScopeName(int rowIndex) {
            return this.getScopeToolState(rowIndex).getExistedStates().get(0).getScopeName();
        }

        @NotNull
        private HighlightSeverity getSeverityState(int rowIndex) {
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty()) {
                return MIXED_FAKE_SEVERITY;
            }
            return ScopesAndSeveritiesTable.getSeverity(existedScopesStatesAndNonExistNames.getExistedStates());
        }

        @Nullable
        private Boolean isEnabled(int rowIndex) {
            Boolean previousValue2 = null;
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            for (ScopeToolState scopeToolState : existedScopesStatesAndNonExistNames.getExistedStates()) {
                boolean currentValue = scopeToolState.isEnabled();
                if (previousValue2 == null) {
                    previousValue2 = currentValue;
                    continue;
                }
                if (previousValue2.equals(currentValue)) continue;
                return null;
            }
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty() && !Boolean.FALSE.equals(previousValue2)) {
                return null;
            }
            return previousValue2;
        }

        private ExistedScopesStatesAndNonExistNames getScopeToolState(int rowIndex) {
            SmartList nonExistNames = new SmartList();
            SmartList existedStates = new SmartList();
            for (String keyName : this.myKeyNames) {
                ScopeToolState scopeToolState = this.getScopeToolState(keyName, rowIndex);
                if (scopeToolState != null) {
                    existedStates.add(scopeToolState);
                    continue;
                }
                nonExistNames.add(keyName);
            }
            return new ExistedScopesStatesAndNonExistNames((List<ScopeToolState>)existedStates, (List<String>)nonExistNames);
        }

        @Nullable
        private ScopeToolState getScopeToolState(String keyName, int rowIndex) {
            if (rowIndex == this.lastRowIndex()) {
                return this.myInspectionProfile.getToolDefaultState(keyName, this.myProject);
            }
            String scopeName = this.myScopeNames[rowIndex];
            List<ScopeToolState> nonDefaultTools = this.myInspectionProfile.getNonDefaultTools(keyName, this.myProject);
            for (ScopeToolState nonDefaultTool : nonDefaultTools) {
                if (!Objects.equals(scopeName, nonDefaultTool.getScopeName())) continue;
                return nonDefaultTool;
            }
            return null;
        }

        private void refreshAggregatedScopes() {
            this.myScopeNames = (String[])this.myKeyNames.stream().map(keyName -> this.myInspectionProfile.getNonDefaultTools((String)keyName, this.myProject)).flatMap(Collection::stream).map(state -> state.getScope(this.myProject)).filter(Objects::nonNull).map(NamedScope::getName).sorted(this.myScopeComparator).toArray(String[]::new);
        }

        private int lastRowIndex() {
            return this.myScopeNames.length;
        }

        @Override
        public void setValueAt(Object value2, int rowIndex, int columnIndex) {
            if (value2 == null) {
                return;
            }
            if (columnIndex == 2) {
                if (value2 == SeverityRenderer.EDIT_SEVERITIES) {
                    return;
                }
                HighlightSeverity severity = (HighlightSeverity)value2;
                HighlightDisplayLevel level = HighlightDisplayLevel.find((String)severity.getName());
                if (level == null) {
                    LOG.error("no display level found for name " + severity.getName());
                    return;
                }
                String scopeName = rowIndex == this.lastRowIndex() ? null : this.getScopeName(rowIndex);
                this.myInspectionProfile.setErrorLevel(this.myKeys, level, scopeName, this.myProject);
            } else if (columnIndex == 0) {
                NamedScope scope = this.getScope(rowIndex);
                if (scope == null) {
                    return;
                }
                if (((Boolean)value2).booleanValue()) {
                    for (String keyName : this.myKeyNames) {
                        this.myInspectionProfile.enableTool(keyName, this.myProject);
                    }
                    if (rowIndex == this.lastRowIndex()) {
                        this.myInspectionProfile.enableToolsByDefault(this.myKeyNames, this.myProject);
                    } else {
                        this.myInspectionProfile.enableTools(this.myKeyNames, scope, this.myProject);
                    }
                } else if (rowIndex == this.lastRowIndex()) {
                    this.myInspectionProfile.disableToolByDefault(this.myKeyNames, this.myProject);
                } else {
                    this.myInspectionProfile.disableTools(this.myKeyNames, scope, this.myProject);
                }
                if (this.myKeyNames.size() == 1) {
                    String keyName = (String)ContainerUtil.getFirstItem(this.myKeyNames);
                    ScopeToolState state = this.getScopeToolState(keyName, rowIndex);
                    this.myTableSettings.onScopeChosen(state);
                }
            }
            this.myTableSettings.onSettingsChanged();
        }

        public void removeRow(int idx) {
            if (idx != this.lastRowIndex()) {
                this.myInspectionProfile.removeScopes(this.myKeyNames, this.getScopeName(idx), this.myProject);
                this.refreshAggregatedScopes();
                this.myTableSettings.onScopeRemoved(this.getRowCount());
            }
        }

        public void addRow() {
            List descriptors = ContainerUtil.map(this.myTableSettings.getNodes(), inspectionConfigTreeNode -> inspectionConfigTreeNode.getDefaultDescriptor());
            ScopesChooser scopesChooser = new ScopesChooser(descriptors, this.myInspectionProfile, this.myProject, this.myScopeNames){

                @Override
                protected void onScopeAdded(@NotNull String scopeName) {
                    myTableSettings.onScopeAdded();
                    this.refreshAggregatedScopes();
                    for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                        if (!this.getScopeName(i2).equals(scopeName)) continue;
                        myTable.clearSelection();
                        myTable.setRowSelectionInterval(i2, i2);
                    }
                }

                @Override
                protected void onScopesOrderChanged() {
                    myTableSettings.onScopesOrderChanged();
                }
            };
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this.myTable));
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("Select a Scope to Change Its Settings", (ActionGroup)scopesChooser.createPopupActionGroup((JComponent)((Object)this.myTable)), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            RelativePoint point = new RelativePoint((Component)((Object)this.myTable), new Point(this.myTable.getWidth() - popup2.getContent().getPreferredSize().width, 0));
            popup2.show(point);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }
    }

    public static abstract class TableSettings {
        private final Collection<InspectionConfigTreeNode.Tool> myNodes;
        private final List<String> myKeyNames;
        private final List<HighlightDisplayKey> myKeys;
        private final InspectionProfileImpl myInspectionProfile;
        private final Project myProject;

        protected TableSettings(@NotNull Collection<InspectionConfigTreeNode.Tool> nodes, @NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project) {
            this.myNodes = nodes;
            this.myKeys = new ArrayList<HighlightDisplayKey>(this.myNodes.size());
            this.myKeyNames = new ArrayList<String>(this.myNodes.size());
            for (InspectionConfigTreeNode.Tool node : nodes) {
                HighlightDisplayKey key = node.getKey();
                this.myKeys.add(key);
                this.myKeyNames.add(key.toString());
            }
            this.myInspectionProfile = inspectionProfile;
            this.myProject = project;
        }

        @NotNull
        public List<HighlightDisplayKey> getKeys() {
            return this.myKeys;
        }

        @NotNull
        public List<String> getKeyNames() {
            return this.myKeyNames;
        }

        @NotNull
        public Collection<InspectionConfigTreeNode.Tool> getNodes() {
            return this.myNodes;
        }

        @NotNull
        public InspectionProfileImpl getInspectionProfile() {
            return this.myInspectionProfile;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        protected abstract void onScopeAdded();

        protected abstract void onScopesOrderChanged();

        protected abstract void onScopeRemoved(int var1);

        protected abstract void onScopeChosen(@NotNull ScopeToolState var1);

        protected abstract void onSettingsChanged();
    }
}

