/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import java.io.IOException;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public final class InspectionProfileLoadUtil {
    private static String getProfileName(@NotNull Path file2, @NotNull Element element2) {
        String name = null;
        for (Element option2 : element2.getChildren("option")) {
            if (!"myName".equals(option2.getAttributeValue("name"))) continue;
            name = option2.getAttributeValue("value");
        }
        if (name == null) {
            name = element2.getAttributeValue("profile_name");
        }
        return name != null ? name : FileUtilRt.getNameWithoutExtension((String)file2.getFileName().toString());
    }

    @NotNull
    public static InspectionProfileImpl load(@NotNull Path file2, @NotNull InspectionToolRegistrar registrar, @NotNull InspectionProfileManager profileManager) throws JDOMException, IOException {
        Element element2 = JDOMUtil.load((Path)file2);
        String profileName = InspectionProfileLoadUtil.getProfileName(file2, element2);
        return InspectionProfileLoadUtil.load(element2, profileName, registrar, profileManager);
    }

    @NotNull
    public static InspectionProfileImpl load(@NotNull Element element2, @NotNull String name, @NotNull InspectionToolsSupplier registrar, @NotNull InspectionProfileManager profileManager) throws InvalidDataException {
        InspectionProfileImpl profile = new InspectionProfileImpl(name, registrar, (BaseInspectionProfileManager)profileManager);
        Element profileElement = element2.getChild("profile");
        if (profileElement != null) {
            element2 = profileElement;
        }
        profile.readExternal(element2);
        return profile;
    }
}

