/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.PathManagerEx;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.jetbrains.annotations.NotNull;

public final class ProjectSelfieUtil {
    @NotNull
    public static Path getSelfieLocation(@NotNull String projectWorkspaceId) {
        return PathManagerEx.getAppSystemDir().resolve("project-selfies").resolve(projectWorkspaceId + ".png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image readProjectSelfie(@NotNull String value2, @NotNull ScaleContext scaleContext) throws IOException {
        BufferedImage bufferedImage;
        Path location = ProjectSelfieUtil.getSelfieLocation(value2);
        try (InputStream input = Files.newInputStream(location, new OpenOption[0]);){
            ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
            try (MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(input);){
                reader.setInput(stream, true, true);
                bufferedImage = reader.read(0, null);
            }
            finally {
                reader.dispose();
            }
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        return ImageUtil.ensureHiDPI((Image)bufferedImage, (ScaleContext)scaleContext);
    }
}

