/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

final class PlatformProjectConfigurator
implements DirectoryProjectConfigurator {
    private static final Logger LOG = Logger.getInstance(PlatformProjectConfigurator.class);

    PlatformProjectConfigurator() {
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules2 = moduleManager.getModules();
        if (modules2.length != 0) {
            LOG.info("PlatformProjectConfigurator is not applicable because modules are already configured (module count: " + modules2.length + ")");
            return;
        }
        String moduleName = baseDir.getName().replace(":", "");
        String imlName = baseDir.getPath() + "/.idea/" + moduleName + ".iml";
        ModuleTypeManager moduleTypeManager = ModuleTypeManager.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module module = moduleManager.newModule(imlName, moduleTypeManager == null ? "unknown" : moduleTypeManager.getDefaultModuleType().getId());
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                VirtualFile[] contentRoots = model.getContentRoots();
                if (contentRoots.length == 0) {
                    model.addContentEntry(baseDir);
                    LOG.debug("content root " + baseDir + " is added");
                } else {
                    LOG.info("content root " + baseDir + " is not added because content roots are already configured (content root count: " + contentRoots.length + ")");
                }
                model.inheritSdk();
                model.commit();
            }
            finally {
                if (!model.isDisposed()) {
                    model.dispose();
                }
            }
            moduleRef.set((Object)module);
        });
    }
}

