/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeFrameProvider;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeFrame
extends JFrame
implements IdeFrame,
AccessibleContextAccessor {
    public static final ExtensionPointName<WelcomeFrameProvider> EP = ExtensionPointName.create((String)"com.intellij.welcomeFrameProvider");
    static final String DIMENSION_KEY = "WELCOME_SCREEN";
    private static IdeFrame ourInstance;
    private static Disposable ourTouchbar;
    private final WelcomeScreen myScreen;
    private final BalloonLayout myBalloonLayout;

    public WelcomeFrame() {
        SplashManager.hideBeforeShow(this);
        JRootPane rootPane = this.getRootPane();
        WelcomeScreen screen = WelcomeFrame.createScreen(rootPane);
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane);
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(screen.getWelcomePanel());
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName());
        AppUIUtil.updateWindowIcon(this);
        final Disposable listenerDisposable = Disposer.newDisposable();
        ApplicationManager.getApplication().getMessageBus().connect(listenerDisposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                Disposer.dispose((Disposable)listenerDisposable);
                WelcomeFrame.this.dispose();
            }
        });
        this.myBalloonLayout = new BalloonLayoutImpl(rootPane, new Insets(8, 8, 8, 8));
        this.myScreen = screen;
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        this.myScreen.setupFrame((JFrame)this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

            public void dispose() {
                WelcomeFrame.this.dispose();
            }
        });
    }

    public static IdeFrame getInstance() {
        return ourInstance;
    }

    @Override
    public void dispose() {
        WelcomeFrame.saveLocation(this.getBounds());
        super.dispose();
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(Rectangle location) {
        location.y = location.height / 2;
        Point middle2 = new Point(location.x + location.width / 2, location.y);
        DimensionService.getInstance().setLocation(DIMENSION_KEY, middle2, null);
    }

    static void setupCloseAction(final @NotNull JFrame frame) {
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProjectUtil.getOpenProjects().length == 0) {
                    ApplicationManager.getApplication().exit();
                } else {
                    frame.dispose();
                }
            }
        });
    }

    private static WelcomeScreen createScreen(JRootPane rootPane) {
        WelcomeScreenProvider provider;
        NewWelcomeScreen screen = null;
        WelcomeScreenProvider[] welcomeScreenProviderArray = (WelcomeScreenProvider[])WelcomeScreenProvider.EP_NAME.getExtensions();
        int n = welcomeScreenProviderArray.length;
        for (int j = 0; !(j >= n || (provider = welcomeScreenProviderArray[j]).isAvailable() && (screen = provider.createWelcomeScreen(rootPane)) != null); ++j) {
        }
        if (screen == null) {
            screen = new NewWelcomeScreen();
        }
        return screen;
    }

    public static void resetInstance() {
        ourInstance = null;
        if (ourTouchbar != null) {
            Disposer.dispose((Disposable)ourTouchbar);
            ourTouchbar = null;
        }
    }

    public static void showNow() {
        Runnable show2;
        if (ourInstance != null) {
            return;
        }
        if (!GeneralSettings.getInstance().isShowWelcomeScreen()) {
            ApplicationManagerEx.getApplicationEx().exit(false, true);
        }
        if ((show2 = WelcomeFrame.prepareToShow()) != null) {
            show2.run();
        }
    }

    @Nullable
    public static Runnable prepareToShow() {
        if (ourInstance != null) {
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ActionManager.getInstance());
        IdeFrame frame = WelcomeFrame.createWelcomeFrame();
        return () -> {
            if (ourInstance != null) {
                return;
            }
            ((JFrame)frame).setVisible(true);
            IdeMenuBar.installAppMenuIfNeeded((JFrame)frame);
            ourInstance = frame;
            if (SystemInfo.isMac) {
                ourTouchbar = TouchBarsManager.showDialogWrapperButtons(frame.getComponent());
            }
        };
    }

    @NotNull
    private static IdeFrame createWelcomeFrame() {
        IdeFrame frame = (IdeFrame)EP.computeSafeIfAny(provider -> provider.createFrame());
        return frame == null ? new WelcomeFrame() : frame;
    }

    public static void showIfNoProjectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
            windowManager.disposeRootFrame();
            if (windowManager.getProjectFrameHelpers().isEmpty()) {
                WelcomeFrame.showNow();
            }
        }, ModalityState.NON_MODAL);
    }

    @Nullable
    public StatusBar getStatusBar() {
        Container pane2 = this.getContentPane();
        return pane2 instanceof JComponent ? (StatusBar)UIUtil.findComponentOfType((JComponent)((JComponent)pane2), IdeStatusBarImpl.class) : null;
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        return this.getBounds();
    }

    @NotNull
    public Project getProject() {
        return ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }
}

