/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarWidgetsActionGroup
extends ActionGroup {
    public static final String GROUP_ID = "ViewStatusBarWidgetsGroup";

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project;
        Project project2 = project = e != null ? e.getProject() : null;
        if (project == null) {
            return AnAction.EMPTY_ARRAY;
        }
        StatusBarWidgetsManager manager = (StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class));
        ArrayList<Object> toggleActions = new ArrayList<Object>(ContainerUtil.map(manager.getWidgetFactories(), x$0 -> new ToggleWidgetAction((StatusBarWidgetFactory)x$0)));
        toggleActions.add(Separator.getInstance());
        toggleActions.add((Object)new HideCurrentWidgetAction());
        return toggleActions.toArray(AnAction.EMPTY_ARRAY);
    }

    private static class HideCurrentWidgetAction
    extends DumbAwareAction {
        private HideCurrentWidgetAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            StatusBarWidgetFactory factory2 = HideCurrentWidgetAction.getFactory(e);
            if (factory2 == null) {
                return;
            }
            ((StatusBarWidgetSettings)((Object)ServiceManager.getService(StatusBarWidgetSettings.class))).setEnabled(factory2, false);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(factory2);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            StatusBarWidgetFactory factory2 = HideCurrentWidgetAction.getFactory(e);
            e.getPresentation().setEnabledAndVisible(factory2 != null && factory2.isConfigurable());
            if (factory2 != null) {
                e.getPresentation().setText(UIBundle.message((String)"status.bar.hide.widget.action.name", (Object[])new Object[]{factory2.getDisplayName()}));
            }
        }

        @Nullable
        private static StatusBarWidgetFactory getFactory(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            String hoveredWidgetId = (String)e.getData(IdeStatusBarImpl.HOVERED_WIDGET_ID);
            StatusBar statusBar = (StatusBar)e.getData(PlatformDataKeys.STATUS_BAR);
            if (project != null && hoveredWidgetId != null && statusBar != null) {
                return ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).findWidgetFactory(hoveredWidgetId);
            }
            return null;
        }
    }

    private static class ToggleWidgetAction
    extends DumbAwareToggleAction {
        private final StatusBarWidgetFactory myWidgetFactory;

        private ToggleWidgetAction(@NotNull StatusBarWidgetFactory widgetFactory) {
            super(widgetFactory.getDisplayName());
            this.myWidgetFactory = widgetFactory;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Project project = e.getProject();
            if (project == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (ActionPlaces.isMainMenuOrShortcut((String)e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(this.myWidgetFactory.isConfigurable() && this.myWidgetFactory.isAvailable(project));
                return;
            }
            StatusBar statusBar = (StatusBar)e.getData(PlatformDataKeys.STATUS_BAR);
            e.getPresentation().setEnabledAndVisible(statusBar != null && ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).canBeEnabledOnStatusBar(this.myWidgetFactory, statusBar));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ((StatusBarWidgetSettings)((Object)ServiceManager.getService(StatusBarWidgetSettings.class))).isEnabled(this.myWidgetFactory);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ((StatusBarWidgetSettings)((Object)ServiceManager.getService(StatusBarWidgetSettings.class))).setEnabled(this.myWidgetFactory, state);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(this.myWidgetFactory);
            }
        }
    }
}

