/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public interface StatusBarWidgetWrapper {
    @NotNull
    public static JComponent wrap(@NotNull StatusBarWidget.WidgetPresentation presentation2) {
        if (presentation2 instanceof StatusBarWidget.IconPresentation) {
            return new Icon((StatusBarWidget.IconPresentation)presentation2);
        }
        if (presentation2 instanceof StatusBarWidget.TextPresentation) {
            return new Text((StatusBarWidget.TextPresentation)presentation2);
        }
        if (presentation2 instanceof StatusBarWidget.MultipleTextValuesPresentation) {
            return new MultipleTextValues((StatusBarWidget.MultipleTextValuesPresentation)presentation2);
        }
        throw new IllegalArgumentException("Unable to find a wrapper for presentation: " + presentation2.getClass().getSimpleName());
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation();

    public void beforeUpdate();

    public static class StatusBarWidgetClickListener
    extends ClickListener {
        private final Consumer<? super MouseEvent> myClickConsumer;

        public StatusBarWidgetClickListener(@NotNull Consumer<? super MouseEvent> consumer) {
            this.myClickConsumer = consumer;
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            if (!e.isPopupTrigger() && 1 == e.getButton()) {
                this.myClickConsumer.consume((Object)e);
            }
            return true;
        }
    }

    public static final class Icon
    extends TextPanel.WithIconAndArrows
    implements StatusBarWidgetWrapper {
        private final StatusBarWidget.IconPresentation myPresentation;

        public Icon(@NotNull StatusBarWidget.IconPresentation presentation2) {
            this.myPresentation = presentation2;
            this.setTextAlignment(0.5f);
            this.setIcon(this.myPresentation.getIcon());
            this.setVisible(this.hasIcon());
            this.setBorder(StatusBarWidget.WidgetBorder.ICON);
            Consumer clickConsumer = this.myPresentation.getClickConsumer();
            if (clickConsumer != null) {
                new StatusBarWidgetClickListener((Consumer<? super MouseEvent>)clickConsumer).installOn((Component)((Object)this), true);
            }
        }

        @Override
        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this.myPresentation;
        }

        @Override
        public void beforeUpdate() {
            this.setIcon(this.myPresentation.getIcon());
            this.setVisible(this.hasIcon());
        }
    }

    public static final class Text
    extends TextPanel
    implements StatusBarWidgetWrapper {
        private final StatusBarWidget.TextPresentation myPresentation;

        public Text(@NotNull StatusBarWidget.TextPresentation presentation2) {
            this.myPresentation = presentation2;
            this.setTextAlignment(presentation2.getAlignment());
            this.setVisible(!this.myPresentation.getText().isEmpty());
            this.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
            Consumer clickConsumer = this.myPresentation.getClickConsumer();
            if (clickConsumer != null) {
                new StatusBarWidgetClickListener((Consumer<? super MouseEvent>)clickConsumer).installOn((Component)((Object)this), true);
            }
        }

        @Override
        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this.myPresentation;
        }

        @Override
        public void beforeUpdate() {
            String text = this.myPresentation.getText();
            this.setText(text);
            this.setVisible(!text.isEmpty());
        }
    }

    public static final class MultipleTextValues
    extends TextPanel.WithIconAndArrows
    implements StatusBarWidgetWrapper {
        private final StatusBarWidget.MultipleTextValuesPresentation myPresentation;

        public MultipleTextValues(@NotNull StatusBarWidget.MultipleTextValuesPresentation presentation2) {
            this.myPresentation = presentation2;
            this.setVisible(StringUtil.isNotEmpty((String)this.myPresentation.getSelectedValue()));
            this.setTextAlignment(0.5f);
            this.setBorder(StatusBarWidget.WidgetBorder.WIDE);
            new ClickListener(){
                private final PopupState myPopupState = new PopupState();

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (this.myPopupState.isRecentlyHidden()) {
                        return false;
                    }
                    ListPopup popup2 = myPresentation.getPopupStep();
                    if (popup2 == null) {
                        return false;
                    }
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(0, -dimension.height);
                    popup2.addListener((JBPopupListener)this.myPopupState);
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }
            }.installOn((Component)((Object)this), true);
        }

        @Override
        public Font getFont() {
            return SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBFont.label();
        }

        @Override
        public void beforeUpdate() {
            String value2 = this.myPresentation.getSelectedValue();
            this.setText(value2);
            this.setIcon(this.myPresentation.getIcon());
            this.setVisible(StringUtil.isNotEmpty((String)value2));
        }

        @Override
        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this.myPresentation;
        }
    }
}

