/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorBasedStatusBarPopup
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    private final PopupState myPopupState = new PopupState();
    private final JPanel myComponent;
    private final boolean myWriteableFileRequired;
    private boolean actionEnabled;
    private final Alarm update;
    private volatile Reference<Editor> myEditor = new WeakReference<Object>(null);

    public EditorBasedStatusBarPopup(@NotNull Project project, boolean writeableFileRequired) {
        super(project);
        this.myWriteableFileRequired = writeableFileRequired;
        this.update = new Alarm((Disposable)this);
        this.myComponent = this.createComponent();
        this.myComponent.setVisible(false);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                EditorBasedStatusBarPopup.this.update();
                EditorBasedStatusBarPopup.this.showPopup(e);
                return true;
            }
        }.installOn((Component)this.myComponent, true);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    protected JPanel createComponent() {
        return new TextPanel.WithIconAndArrows();
    }

    public final void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile newFile = event.getNewFile();
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.setEditor(editor);
        this.fileChanged(newFile);
    }

    @ApiStatus.Internal
    public final void setEditor(@Nullable Editor editor) {
        this.myEditor = new WeakReference<Editor>(editor);
    }

    public final void selectionChanged(@Nullable VirtualFile newFile) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.myEditor = new WeakReference<Editor>(editor);
        this.fileChanged(newFile);
    }

    private void fileChanged(VirtualFile newFile) {
        this.handleFileChange(newFile);
        this.update();
    }

    protected void handleFileChange(VirtualFile file2) {
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.fileChanged(file2);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.fileChanged(file2);
    }

    public final StatusBarWidget copy() {
        return this.createInstance(this.getProject());
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        this.registerCustomListeners();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                Document document = e.getDocument();
                EditorBasedStatusBarPopup.this.updateForDocument(document);
            }
        }, (Disposable)this);
        if (this.myWriteableFileRequired) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

                public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                    if ("writable".equals(event.getPropertyName())) {
                        EditorBasedStatusBarPopup.this.updateForFile(event.getFile());
                    }
                }
            }));
        }
        this.setEditor(this.getEditor());
        this.update();
    }

    protected void updateForDocument(@Nullable(value="null means update anyway") @Nullable(value="null means update anyway") Document document) {
        Editor selectedEditor = this.myEditor.get();
        if (document != null && (selectedEditor == null || selectedEditor.getDocument() != document)) {
            return;
        }
        this.update();
    }

    protected void updateForFile(@Nullable(value="null means update anyway") @Nullable(value="null means update anyway") VirtualFile file2) {
        if (file2 == null) {
            this.update();
        } else {
            this.updateForDocument(FileDocumentManager.getInstance().getCachedDocument(file2));
        }
    }

    private void showPopup(@NotNull MouseEvent e) {
        if (!this.actionEnabled || this.myPopupState.isRecentlyHidden()) {
            return;
        }
        DataContext dataContext = this.getContext();
        ListPopup popup2 = this.createPopup(dataContext);
        if (popup2 != null) {
            Dimension dimension = popup2.getContent().getPreferredSize();
            Point at = new Point(0, -dimension.height);
            popup2.addListener((JBPopupListener)this.myPopupState);
            popup2.show(new RelativePoint(e.getComponent(), at));
            Disposer.register((Disposable)this, (Disposable)popup2);
        }
    }

    @NotNull
    protected DataContext getContext() {
        VirtualFile[] virtualFileArray;
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        VirtualFile selectedFile = this.getSelectedFile();
        ContainerUtil.ImmutableMapBuilder immutableMapBuilder = ContainerUtil.immutableMapBuilder().put((Object)CommonDataKeys.VIRTUAL_FILE.getName(), (Object)selectedFile);
        String string = CommonDataKeys.VIRTUAL_FILE_ARRAY.getName();
        if (selectedFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = selectedFile;
        }
        return SimpleDataContext.getSimpleContext(immutableMapBuilder.put((Object)string, (Object)virtualFileArray).put((Object)CommonDataKeys.PROJECT.getName(), (Object)this.getProject()).put((Object)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)(editor == null ? null : editor.getComponent())).build(), parent);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    protected boolean isEmpty() {
        Boolean result2 = (Boolean)ObjectUtils.doIfCast((Object)this.myComponent, TextPanel.WithIconAndArrows.class, textPanel -> StringUtil.isEmpty((String)textPanel.getText()) && !textPanel.hasIcon());
        return result2 != null && result2 != false;
    }

    public boolean isActionEnabled() {
        return this.actionEnabled;
    }

    protected void updateComponent(@NotNull WidgetState state) {
        this.myComponent.setToolTipText(state.toolTip);
        ObjectUtils.consumeIfCast((Object)this.myComponent, TextPanel.WithIconAndArrows.class, textPanel -> {
            textPanel.setTextAlignment(0.5f);
            textPanel.setIcon(state.icon);
            textPanel.setText(state.text);
        });
    }

    public void updateInTests(boolean immediately) {
        this.update();
        this.update.drainRequestsInTest();
        UIUtil.dispatchAllInvocationEvents();
        if (immediately) {
            this.update.drainRequestsInTest();
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    public void flushUpdateInTests() {
        this.update.drainRequestsInTest();
    }

    public void update() {
        this.update(null);
    }

    public void update(@Nullable Runnable finishUpdate) {
        if (this.update.isDisposed()) {
            return;
        }
        this.update.cancelAllRequests();
        this.update.addRequest(() -> {
            if (this.isDisposed()) {
                return;
            }
            VirtualFile file2 = this.getSelectedFile();
            WidgetState state = this.getWidgetState(file2);
            if (state == WidgetState.NO_CHANGE) {
                return;
            }
            if (state == WidgetState.NO_CHANGE_MAKE_VISIBLE) {
                this.myComponent.setVisible(true);
                return;
            }
            if (state == WidgetState.HIDDEN) {
                this.myComponent.setVisible(false);
                return;
            }
            this.myComponent.setVisible(true);
            this.actionEnabled = state.actionEnabled && this.isEnabledForFile(file2);
            this.myComponent.setEnabled(this.actionEnabled);
            this.updateComponent(state);
            if (this.myStatusBar != null && !this.myComponent.isValid()) {
                this.myStatusBar.updateWidget(this.ID());
            }
            if (finishUpdate != null) {
                finishUpdate.run();
            }
            this.afterVisibleUpdate(state);
        }, 200, ModalityState.any());
    }

    protected void afterVisibleUpdate(@NotNull WidgetState state) {
    }

    @NotNull
    protected abstract WidgetState getWidgetState(@Nullable VirtualFile var1);

    protected boolean isEnabledForFile(@Nullable VirtualFile file2) {
        return file2 == null || !this.myWriteableFileRequired || file2.isWritable();
    }

    @Nullable
    protected abstract ListPopup createPopup(DataContext var1);

    protected void registerCustomListeners() {
    }

    @NotNull
    protected abstract StatusBarWidget createInstance(@NotNull Project var1);

    protected static class WidgetState {
        public static final WidgetState HIDDEN = new WidgetState();
        public static final WidgetState NO_CHANGE = new WidgetState();
        public static final WidgetState NO_CHANGE_MAKE_VISIBLE = new WidgetState();
        protected final String toolTip;
        private final String text;
        private final boolean actionEnabled;
        private Icon icon;

        private WidgetState() {
            this("", "", false);
        }

        public WidgetState(@NlsContexts.Tooltip String toolTip, @NlsContexts.StatusBarText String text, boolean actionEnabled) {
            this.toolTip = toolTip;
            this.text = text;
            this.actionEnabled = actionEnabled;
        }

        public static WidgetState getDumbModeState(String name, String widgetPrefix) {
            return new WidgetState(ActionUtil.getUnavailableMessage((String)name, (boolean)false), widgetPrefix + IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]), false);
        }

        public void setIcon(Icon icon2) {
            this.icon = icon2;
        }

        public String getText() {
            return this.text;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

