/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.ui.layout.migLayout.MigLayoutUtilKt;
import com.intellij.ui.layout.migLayout.patched.MigLayout;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.Alarm;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LocationOnDragTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowContentUi
implements ContentUI,
DataProvider {
    public static final String HIDE_ID_LABEL = "HideIdLabel";
    private static final String TOOLWINDOW_UI_INSTALLED = "ToolWindowUiInstalled";
    @NotNull
    private final ContentManager contentManager;
    private final JPanel contentComponent;
    final ToolWindowImpl window;
    private final TabbedContentAction.CloseAllAction closeAllAction;
    private final TabbedContentAction.MyNextTabAction nextTabAction;
    private final TabbedContentAction.MyPreviousTabAction previousTabAction;
    private final ShowContentAction showContent;
    private final TabContentLayout tabsLayout;
    private ContentLayout myComboLayout;
    private ToolWindowContentUiType type;
    public Predicate<Point> isResizableArea = p -> true;
    private final JPanel tabComponent = new TabPanel();

    @NotNull
    public ContentManager getContentManager() {
        return this.contentManager;
    }

    @NotNull
    public JPanel getTabComponent() {
        return this.tabComponent;
    }

    public ToolWindowContentUi(final @NotNull ToolWindowImpl window, final @NotNull ContentManager contentManager2, final @NotNull JPanel contentComponent) {
        this.contentManager = contentManager2;
        this.type = window.getWindowInfo().getContentUiType();
        this.tabsLayout = new TabContentLayout(this);
        this.window = window;
        this.contentComponent = contentComponent;
        this.getCurrentLayout().init(contentManager2);
        contentManager2.addContentManagerListener(new ContentManagerListener(){
            private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    ToolWindowContentUi.this.update();
                }
            };

            public void contentAdded(@NotNull ContentManagerEvent event) {
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                event.getContent().addPropertyChangeListener(this.propertyChangeListener);
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                event.getContent().removePropertyChangeListener(this.propertyChangeListener);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
                if (contentManager2.getContentCount() == 0 && window.isToHideOnEmptyContent()) {
                    window.hide(null);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                contentComponent.revalidate();
                contentComponent.repaint();
            }
        });
        ToolWindowContentUi.initMouseListeners(this.tabComponent, this, true);
        this.closeAllAction = new TabbedContentAction.CloseAllAction(contentManager2);
        this.nextTabAction = new TabbedContentAction.MyNextTabAction(contentManager2);
        this.previousTabAction = new TabbedContentAction.MyPreviousTabAction(contentManager2);
        this.showContent = new ShowContentAction(window, contentComponent, (Disposable)contentManager2);
    }

    @NotNull
    public String getToolWindowId() {
        return this.window.getId();
    }

    private boolean isResizeable() {
        if (this.window.getType() == ToolWindowType.FLOATING || this.window.getType() == ToolWindowType.WINDOWED) {
            return false;
        }
        if (this.window.getAnchor() == ToolWindowAnchor.BOTTOM) {
            return true;
        }
        if (this.window.getAnchor() == ToolWindowAnchor.TOP || !this.window.isSplitMode()) {
            return false;
        }
        ToolWindowManagerImpl manager = this.window.getToolWindowManager();
        for (String id2 : manager.getIdsOn(this.window.getAnchor())) {
            ToolWindow window;
            if (id2.equals(this.window.getId()) || (window = manager.getToolWindow(id2)) == null || !window.isVisible() || window.getType() != ToolWindowType.DOCKED && window.getType() != ToolWindowType.SLIDING) continue;
            return true;
        }
        return false;
    }

    private boolean isResizeable(@NotNull Point point) {
        return this.isResizableArea.apply((Object)point);
    }

    public void setType(@NotNull ToolWindowContentUiType type) {
        if (this.type == type) {
            return;
        }
        if (this.type != null) {
            this.getCurrentLayout().reset();
        }
        this.type = type;
        this.getCurrentLayout().init(this.contentManager);
        this.rebuild();
    }

    @NotNull
    private ContentLayout getCurrentLayout() {
        if (this.type == ToolWindowContentUiType.TABBED) {
            return this.tabsLayout;
        }
        if (this.myComboLayout == null) {
            this.myComboLayout = new ComboContentLayout(this);
        }
        return this.myComboLayout;
    }

    public JComponent getComponent() {
        return this.contentComponent;
    }

    public void setManager(@NotNull ContentManager manager) {
        throw new UnsupportedOperationException();
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected2 = this.contentManager.getSelectedContent();
        if (selected2 == null) {
            this.contentComponent.removeAll();
            return;
        }
        if (this.contentComponent.getComponentCount() == 1 && (visible = this.contentComponent.getComponent(0)) == selected2.getComponent()) {
            return;
        }
        this.contentComponent.removeAll();
        this.contentComponent.add((Component)selected2.getComponent(), "Center");
        this.contentComponent.revalidate();
        this.contentComponent.repaint();
    }

    public void dropCaches() {
        this.tabsLayout.dropCaches();
    }

    private void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.tabComponent.revalidate();
        this.tabComponent.repaint();
    }

    private void update() {
        this.getCurrentLayout().update();
        this.getCurrentLayout().layout();
        this.tabComponent.revalidate();
        this.tabComponent.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        return this.getCurrentLayout().getCloseActionName();
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        return this.getCurrentLayout().getCloseAllButThisActionName();
    }

    @NotNull
    public String getPreviousContentActionName() {
        return this.getCurrentLayout().getPreviousContentActionName();
    }

    @NotNull
    public String getNextContentActionName() {
        return this.getCurrentLayout().getNextContentActionName();
    }

    public void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        this.tabsLayout.setTabDoubleClickActions(actions);
    }

    public static void initMouseListeners(final @NotNull JComponent c, final @NotNull ToolWindowContentUi ui, final boolean allowResize) {
        if (c.getClientProperty(TOOLWINDOW_UI_INSTALLED) != null) {
            return;
        }
        MouseAdapter mouseAdapter2 = new MouseAdapter(){
            final Ref<Point> myLastPoint = Ref.create();
            final Ref<Point> myPressPoint = Ref.create();
            final Ref<Integer> myInitialHeight = Ref.create((Object)0);
            final Ref<Boolean> myIsLastComponent = Ref.create();
            final Ref<LocationOnDragTracker> myDragTracker = Ref.create();

            private Component getActualSplitter() {
                if (!allowResize || !ui.isResizeable()) {
                    return null;
                }
                Container component2 = c;
                for (Container parent = component2.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof ThreeComponentsSplitter && ((ThreeComponentsSplitter)parent).getOrientation() && component2 != ((ThreeComponentsSplitter)parent).getFirstComponent()) {
                        return parent;
                    }
                    if (parent instanceof Splitter && ((Splitter)parent).isVertical() && ((Splitter)parent).getSecondComponent() == component2 && ((Splitter)parent).getFirstComponent() != null) {
                        return parent;
                    }
                    component2 = parent;
                }
                return null;
            }

            private void arm(Component c2) {
                Component component2;
                Component component3 = component2 = c2 != null ? this.getActualSplitter() : null;
                if (component2 instanceof ThreeComponentsSplitter) {
                    ThreeComponentsSplitter splitter = (ThreeComponentsSplitter)component2;
                    this.myIsLastComponent.set((Object)SwingUtilities.isDescendingFrom(c2, splitter.getLastComponent()));
                    this.myInitialHeight.set((Object)((Boolean)this.myIsLastComponent.get() != false ? splitter.getLastSize() : splitter.getFirstSize()));
                    return;
                }
                if (component2 instanceof Splitter) {
                    Splitter splitter = (Splitter)component2;
                    this.myIsLastComponent.set((Object)true);
                    this.myInitialHeight.set((Object)splitter.getSecondComponent().getHeight());
                    return;
                }
                this.myIsLastComponent.set(null);
                this.myInitialHeight.set(null);
                this.myPressPoint.set(null);
                this.myDragTracker.set(null);
            }

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                PointerInfo info = MouseInfo.getPointerInfo();
                if (!e.isPopupTrigger() && !UIUtil.isCloseClick((MouseEvent)e)) {
                    this.myLastPoint.set((Object)(info != null ? info.getLocation() : e.getLocationOnScreen()));
                    this.myPressPoint.set(this.myLastPoint.get());
                    this.myDragTracker.set((Object)LocationOnDragTracker.startDrag((MouseEvent)e));
                    if (allowResize && ui.isResizeable()) {
                        this.arm(c.getComponentAt(e.getPoint()) == c && ui.isResizeable(e.getPoint()) ? c : null);
                    }
                    ui.window.fireActivated();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        ui.processHide(e);
                    }
                    this.arm(null);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                c.setCursor(allowResize && ui.isResizeable() && this.getActualSplitter() != null && c.getComponentAt(e.getPoint()) == c && ui.isResizeable(e.getPoint()) ? Cursor.getPredefinedCursor(8) : Cursor.getDefaultCursor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                c.setCursor(null);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ThreeComponentsSplitter splitter;
                if (this.myLastPoint.isNull() || this.myPressPoint.isNull() || this.myDragTracker.isNull()) {
                    return;
                }
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info == null) {
                    return;
                }
                Point newMouseLocation = info.getLocation();
                Window window = SwingUtilities.windowForComponent(c);
                if (!(window instanceof IdeFrame)) {
                    ((LocationOnDragTracker)this.myDragTracker.get()).updateLocationOnDrag((Component)window);
                }
                this.myLastPoint.set((Object)newMouseLocation);
                Component component2 = this.getActualSplitter();
                if (component2 instanceof ThreeComponentsSplitter) {
                    splitter = (ThreeComponentsSplitter)component2;
                    if (this.myIsLastComponent.get() == Boolean.TRUE) {
                        splitter.setLastSize((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y);
                    } else {
                        splitter.setFirstSize((Integer)this.myInitialHeight.get() + ((Point)this.myLastPoint.get()).y - ((Point)this.myPressPoint.get()).y);
                    }
                }
                if (component2 instanceof Splitter) {
                    splitter = (Splitter)component2;
                    splitter.setProportion(Math.max(0.0f, Math.min(1.0f, 1.0f - (float)((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y) / (float)splitter.getHeight())));
                }
            }
        };
        c.addMouseMotionListener(mouseAdapter2);
        c.addMouseListener(mouseAdapter2);
        c.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Content content2 = c instanceof BaseLabel ? ((BaseLabel)c).getContent() : null;
                ui.showContextMenu(comp, x, y, ui.window.getPopupGroup(), content2);
            }
        });
        c.putClientProperty(TOOLWINDOW_UI_INSTALLED, Boolean.TRUE);
    }

    private void initActionGroup(@NotNull DefaultActionGroup group, @Nullable Content content2) {
        TabGroupId groupId2;
        if (content2 == null) {
            return;
        }
        group.addSeparator();
        group.add((AnAction)new TabbedContentAction.CloseAction(content2));
        group.add((AnAction)this.closeAllAction);
        group.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content2));
        group.addSeparator();
        if (content2.isPinnable()) {
            group.add(PinToolwindowTabAction.getPinAction());
            group.addSeparator();
        }
        group.add((AnAction)this.nextTabAction);
        group.add((AnAction)this.previousTabAction);
        group.add((AnAction)this.showContent);
        if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
            group.addAction(ToolWindowContentUi.createSplitTabsAction((TabbedContent)content2));
        }
        if (Boolean.TRUE == content2.getUserData(Content.TABBED_CONTENT_KEY) && (groupId2 = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY)) != null) {
            group.addAction(ToolWindowContentUi.createMergeTabsAction(this.contentManager, groupId2));
        }
        group.addSeparator();
    }

    public void showContextMenu(Component comp, int x, int y, ActionGroup toolWindowGroup, @Nullable Content selectedContent) {
        if (selectedContent == null && toolWindowGroup == null) {
            return;
        }
        DefaultActionGroup configuredGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("ToolWindowContextMenu");
        DefaultActionGroup group = new DefaultActionGroup();
        group.copyFromGroup(configuredGroup);
        if (selectedContent != null) {
            this.initActionGroup(group, selectedContent);
        }
        if (toolWindowGroup != null) {
            group.addAll(toolWindowGroup);
        }
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group);
        popupMenu.getComponent().show(comp, x, y);
    }

    @NotNull
    private static AnAction createSplitTabsAction(final @NotNull TabbedContent content2) {
        return new DumbAwareAction(IdeBundle.message((String)"action.text.split.0.group", (Object[])new Object[]{content2.getTitlePrefix()})){

            public void actionPerformed(@NotNull AnActionEvent e) {
                content2.split();
            }
        };
    }

    @NotNull
    private static AnAction createMergeTabsAction(final @NotNull ContentManager manager, final @NotNull TabGroupId groupId2) {
        return new DumbAwareAction(IdeBundle.message((String)"action.text.merge.tabs.to.0.group", (Object[])new Object[]{groupId2.getDisplayName()})){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ContentUtilEx.mergeTabs(manager, groupId2);
            }
        };
    }

    private void processHide(@NotNull MouseEvent e) {
        IdeEventQueue.getInstance().blockNextEvents(e);
        Component c = e.getComponent();
        if (c instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c;
            if (tab.getContent() != null) {
                if (this.contentManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.contentManager.removeContent(tab.getContent(), true, true, true);
                } else if (this.contentManager.getContentCount() == 1) {
                    this.hideWindow(e);
                }
            } else {
                this.hideWindow(e);
            }
        } else {
            this.hideWindow(e);
        }
    }

    private void hideWindow(@NotNull MouseEvent e) {
        if (e.isControlDown()) {
            this.window.fireHiddenSide();
        } else {
            this.window.fireHidden();
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.window;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.window.getToolWindowManager().getProject();
        }
        if (CloseAction.CloseTarget.KEY.is(dataId)) {
            return this.computeCloseTarget();
        }
        if (MorePopupAware.KEY.is(dataId)) {
            ContentLayout layout = this.getCurrentLayout();
            return layout instanceof TabContentLayout ? layout : null;
        }
        return null;
    }

    @NotNull
    private CloseAction.CloseTarget computeCloseTarget() {
        Content selected2;
        if (this.contentManager.canCloseContents() && (selected2 = this.contentManager.getSelectedContent()) != null && selected2.isCloseable()) {
            return new CloseContentTarget(selected2);
        }
        return new HideToolwindowTarget();
    }

    boolean isCurrent(ContentLayout layout) {
        return this.getCurrentLayout() == layout;
    }

    public static void toggleContentPopup(@NotNull ToolWindowContentUi content2, @NotNull ContentManager contentManager2) {
        ToolWindowContentUi.toggleContentPopup(content2, contentManager2, null);
    }

    static void toggleContentPopup(@NotNull ToolWindowContentUi content2, @NotNull ContentManager contentManager2, JBPopupListener listener2) {
        SelectContentStep step = new SelectContentStep(contentManager2.getContents());
        Content selectedContent = contentManager2.getSelectedContent();
        if (selectedContent != null) {
            step.setDefaultOptionIndex(contentManager2.getIndexOfContent(selectedContent));
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (listener2 != null) {
            popup2.addListener(listener2);
        }
        content2.getCurrentLayout().showContentPopup(popup2);
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup2).addRequest(() -> popup2.handleSelect(false), 50);
        }
    }

    private final class TabPanel
    extends JPanel
    implements UISettingsListener {
        private TabPanel() {
            super(new MigLayout(MigLayoutUtilKt.createLayoutConstraints(0, 0).noVisualPadding().fillY()));
            this.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            this.revalidate();
            this.repaint();
        }

        @Override
        public void doLayout() {
            ToolWindowContentUi.this.getCurrentLayout().layout();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ToolWindowContentUi.this.getCurrentLayout().paintComponent(g);
        }

        @Override
        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(insets.left + insets.right + ToolWindowContentUi.this.getCurrentLayout().getMinimumWidth(), super.getMinimumSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension();
            size.height = 0;
            size.width = 4 + this.getInsets().left + this.getInsets().right;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Component each = this.getComponent(i2);
                size.height = Math.max(each.getPreferredSize().height, size.height);
                size.width += each.getPreferredSize().width;
            }
            size.width = Math.max(size.width, this.getMinimumSize().width);
            return size;
        }
    }

    private final class CloseContentTarget
    implements CloseAction.CloseTarget {
        private final Content myContent;

        private CloseContentTarget(Content content2) {
            this.myContent = content2;
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.contentManager.removeContent(this.myContent, true, true, true);
        }
    }

    private final class HideToolwindowTarget
    implements CloseAction.CloseTarget {
        private HideToolwindowTarget() {
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.window.fireHidden();
        }
    }
}

