/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.sun.jna.platform.WindowUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import kotlin.Metadata;
import org.jetbrains.annotations.NonNls;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\n\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"FOCUSED_WINDOW_PROPERTY_NAME", "", "FRAME_ELEMENT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "calcAlphaModelSupported", "", "getIdeFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "component", "Ljava/awt/Component;", "setAlphaMode", "", "window", "Ljava/awt/Window;", "ratio", "", "tryToFindTheOnlyFrame", "intellij.platform.ide.impl"})
public final class WindowManagerImplKt {
    private static final Logger LOG;
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";

    private static final boolean calcAlphaModelSupported() {
        boolean bl;
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (device.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            return true;
        }
        try {
            bl = WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    private static final void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfoRt.isMac) {
                Window window2 = window;
                if (window2 instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window2 instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window2 instanceof JFrame) {
                    ((JFrame)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                window.setOpacity(1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    private static final IdeFrame tryToFindTheOnlyFrame() {
        IdeFrameImpl candidate = null;
        for (Frame each : Frame.getFrames()) {
            if (!(each instanceof IdeFrameImpl)) continue;
            if (candidate == null) {
                candidate = (IdeFrameImpl)each;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate == null ? null : (IdeFrame)ProjectFrameHelper.getFrameHelper(candidate);
    }

    private static final IdeFrame getIdeFrame(Component component2) {
        Component component3 = component2;
        return component3 instanceof IdeFrameImpl ? (IdeFrame)ProjectFrameHelper.getFrameHelper((Window)component2) : (component3 instanceof IdeFrame ? (IdeFrame)component2 : null);
    }

    static {
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(WindowManagerImpl.class);
    }

    public static final /* synthetic */ boolean access$calcAlphaModelSupported() {
        return WindowManagerImplKt.calcAlphaModelSupported();
    }

    public static final /* synthetic */ void access$setAlphaMode(Window window, float ratio) {
        WindowManagerImplKt.setAlphaMode(window, ratio);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ IdeFrame access$tryToFindTheOnlyFrame() {
        return WindowManagerImplKt.tryToFindTheOnlyFrame();
    }

    public static final /* synthetic */ IdeFrame access$getIdeFrame(Component component2) {
        return WindowManagerImplKt.getIdeFrame(component2);
    }
}

