/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.ProjectWindowAction;
import com.intellij.platform.ModuleAttachProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectWindowActionGroup
extends DefaultActionGroup {
    private ProjectWindowAction latest = null;

    public void addProject(@NotNull Project project) {
        String projectLocation = project.getPresentableUrl();
        if (projectLocation == null) {
            return;
        }
        String projectName = ProjectWindowActionGroup.getProjectDisplayName(project);
        ProjectWindowAction windowAction = new ProjectWindowAction(projectName, projectLocation, this.latest);
        List<ProjectWindowAction> duplicateWindowActions = this.findWindowActionsWithProjectName(projectName);
        if (!duplicateWindowActions.isEmpty()) {
            for (ProjectWindowAction action2 : duplicateWindowActions) {
                action2.getTemplatePresentation().setText(FileUtil.getLocationRelativeToUserHome((String)action2.getProjectLocation()));
            }
            windowAction.getTemplatePresentation().setText(FileUtil.getLocationRelativeToUserHome((String)windowAction.getProjectLocation()));
        }
        this.add((AnAction)windowAction);
        this.latest = windowAction;
    }

    @NotNull
    private static String getProjectDisplayName(@NotNull Project project) {
        String name = ModuleAttachProcessor.getMultiProjectDisplayName(project);
        return name != null ? name : project.getName();
    }

    public void removeProject(@NotNull Project project) {
        ProjectWindowAction windowAction = this.findWindowAction(project.getPresentableUrl());
        if (windowAction == null) {
            return;
        }
        if (this.latest == windowAction) {
            ProjectWindowAction previous = this.latest.getPrevious();
            this.latest = previous != this.latest ? previous : null;
        }
        this.remove((AnAction)windowAction);
        String projectName = ProjectWindowActionGroup.getProjectDisplayName(project);
        List<ProjectWindowAction> duplicateWindowActions = this.findWindowActionsWithProjectName(projectName);
        if (duplicateWindowActions.size() == 1) {
            duplicateWindowActions.get(0).getTemplatePresentation().setText(projectName);
        }
        windowAction.dispose();
    }

    public boolean isEnabled() {
        return this.latest != null && this.latest.getPrevious() != this.latest;
    }

    public boolean isDumbAware() {
        return true;
    }

    public void activateNextWindow(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ProjectWindowAction windowAction = this.findWindowAction(project.getPresentableUrl());
        if (windowAction == null) {
            return;
        }
        ProjectWindowAction next = windowAction.getNext();
        if (next != null) {
            next.setSelected(e, true);
        }
    }

    public void activatePreviousWindow(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ProjectWindowAction windowAction = this.findWindowAction(project.getPresentableUrl());
        if (windowAction == null) {
            return;
        }
        ProjectWindowAction previous = windowAction.getPrevious();
        if (previous != null) {
            previous.setSelected(e, true);
        }
    }

    @Nullable
    private ProjectWindowAction findWindowAction(String projectLocation) {
        AnAction[] children2;
        if (projectLocation == null) {
            return null;
        }
        for (AnAction child2 : children2 = this.getChildren(null)) {
            ProjectWindowAction windowAction;
            if (!(child2 instanceof ProjectWindowAction) || !projectLocation.equals((windowAction = (ProjectWindowAction)child2).getProjectLocation())) continue;
            return windowAction;
        }
        return null;
    }

    private List<ProjectWindowAction> findWindowActionsWithProjectName(String projectName) {
        AnAction[] children2;
        ArrayList<ProjectWindowAction> result2 = null;
        for (AnAction child2 : children2 = this.getChildren(null)) {
            ProjectWindowAction windowAction;
            if (!(child2 instanceof ProjectWindowAction) || !projectName.equals((windowAction = (ProjectWindowAction)child2).getProjectName())) continue;
            if (result2 == null) {
                result2 = new ArrayList<ProjectWindowAction>();
            }
            result2.add(windowAction);
        }
        if (result2 == null) {
            return Collections.emptyList();
        }
        return result2;
    }
}

