/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VfsEventGenerationHelper {
    static final Logger LOG = Logger.getInstance(RefreshWorker.class);
    private final List<VFileEvent> myEvents = new ArrayList<VFileEvent>();
    private int myMarkedStart = -1;

    VfsEventGenerationHelper() {
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        return this.myEvents;
    }

    static boolean checkDirty(@NotNull NewVirtualFile file2) {
        boolean fileDirty = file2.isDirty();
        if (LOG.isTraceEnabled()) {
            LOG.trace("file=" + file2 + " dirty=" + fileDirty);
        }
        return fileDirty;
    }

    void checkContentChanged(@NotNull VirtualFile file2, long oldTimestamp, long newTimestamp, long oldLength, long newLength) {
        if (oldTimestamp != newTimestamp || oldLength != newLength) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("update file=" + file2 + (oldTimestamp != newTimestamp ? " TS=" + oldTimestamp + "->" + newTimestamp : "") + (oldLength != newLength ? " len=" + oldLength + "->" + newLength : ""));
            }
            this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, oldTimestamp, newTimestamp, oldLength, newLength, true));
        }
    }

    void scheduleCreation(@NotNull VirtualFile parent, @NotNull String childName, @NotNull FileAttributes attributes, @Nullable String symlinkTarget, @NotNull ThrowableRunnable<RefreshWorker.RefreshCancelledException> checkCanceled) throws RefreshWorker.RefreshCancelledException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("create parent=" + parent + " name=" + childName + " attr=" + attributes);
        }
        ChildInfo[] children2 = null;
        if (attributes.isDirectory() && parent.getFileSystem() instanceof LocalFileSystem && !attributes.isSymLink()) {
            try {
                Path child2 = Paths.get(parent.getPath(), childName);
                if (VfsEventGenerationHelper.shouldScanDirectory(parent, child2, childName)) {
                    List relevantExcluded = ContainerUtil.mapNotNull(ProjectManagerEx.getInstanceEx().getAllExcludedUrls(), url -> {
                        Path path = Paths.get(VirtualFileManager.extractPath((String)url), new String[0]);
                        return path.startsWith(child2) ? path : null;
                    });
                    children2 = VfsEventGenerationHelper.scanChildren(child2, relevantExcluded, checkCanceled);
                }
            }
            catch (InvalidPathException e) {
                LOG.warn("Invalid child name: '" + childName + "'", (Throwable)e);
            }
        }
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, attributes.isDirectory(), attributes, symlinkTarget, true, children2));
    }

    private static boolean shouldScanDirectory(@NotNull VirtualFile parent, @NotNull Path child2, @NotNull String childName) {
        if (FileTypeManager.getInstance().isFileIgnored(childName)) {
            return false;
        }
        for (Project openProject2 : ProjectManager.getInstance().getOpenProjects()) {
            Path path;
            if (((Boolean)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)openProject2).isUnderIgnored(parent))).booleanValue()) {
                return false;
            }
            String projectRootPath = openProject2.getBasePath();
            if (projectRootPath == null || !child2.startsWith(path = Paths.get(projectRootPath, new String[0]))) continue;
            return true;
        }
        return false;
    }

    void beginTransaction() {
        this.myMarkedStart = this.myEvents.size();
    }

    void endTransaction(boolean success) {
        if (!success) {
            this.myEvents.subList(this.myMarkedStart, this.myEvents.size()).clear();
        }
        this.myMarkedStart = -1;
    }

    private static ChildInfo @Nullable [] scanChildren(final @NotNull Path root, final @NotNull List<Path> excluded, final @NotNull ThrowableRunnable<RefreshWorker.RefreshCancelledException> checkCanceled) throws RefreshWorker.RefreshCancelledException {
        final Stack stack = new Stack();
        ChildInfoImpl fakeRoot = new ChildInfoImpl(-238, "", null, null, null);
        stack.push((Object)new SmartList((Object)fakeRoot));
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
            int checkCanceledCount;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!dir.equals(root)) {
                    this.visitFile(dir, attrs);
                }
                if (excluded.contains(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                stack.push(new ArrayList());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                if ((++this.checkCanceledCount & 0xF) == 0) {
                    checkCanceled.run();
                }
                String name = file2.getFileName().toString();
                boolean isSymLink = false;
                if (attrs.isSymbolicLink()) {
                    isSymLink = true;
                    attrs = Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]);
                }
                FileAttributes attributes = LocalFileSystemRefreshWorker.toFileAttributes(file2, attrs, isSymLink);
                String symLinkTarget = isSymLink ? FileUtil.toSystemIndependentName((String)file2.toRealPath(new LinkOption[0]).toString()) : null;
                ChildInfoImpl info = new ChildInfoImpl(-238, name, attributes, null, symLinkTarget);
                ((List)stack.peek()).add(info);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                List childInfos = (List)stack.pop();
                List parentInfos = (List)stack.peek();
                ChildInfo parentInfo = (ChildInfo)ContainerUtil.getLastItem((List)parentInfos);
                ChildInfo[] children2 = childInfos.toArray(ChildInfo.EMPTY_ARRAY);
                ChildInfoImpl newInfo = new ChildInfoImpl(parentInfo.getId(), parentInfo.getNameId(), parentInfo.getFileAttributes(), children2, parentInfo.getSymlinkTarget());
                parentInfos.set(parentInfos.size() - 1, newInfo);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file2, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        return ((ChildInfo)((List)stack.pop()).get(0)).getChildren();
    }

    void scheduleDeletion(@NotNull VirtualFile file2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete file=" + file2);
        }
        this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file2, true));
    }

    void checkSymbolicLinkChange(@NotNull VirtualFile child2, String oldTarget, String currentTarget) {
        String currentVfsTarget;
        String string = currentVfsTarget = currentTarget != null ? FileUtil.toSystemIndependentName((String)currentTarget) : null;
        if (!Objects.equals(oldTarget, currentVfsTarget)) {
            this.scheduleAttributeChange(child2, "symlink", oldTarget, currentVfsTarget);
        }
    }

    void checkHiddenAttributeChange(@NotNull VirtualFile child2, boolean oldHidden, boolean newHidden) {
        if (oldHidden != newHidden) {
            this.scheduleAttributeChange(child2, "HIDDEN", oldHidden, newHidden);
        }
    }

    void checkWritableAttributeChange(@NotNull VirtualFile file2, boolean oldWritable, boolean newWritable) {
        if (oldWritable != newWritable) {
            this.scheduleAttributeChange(file2, "writable", oldWritable, newWritable);
        }
    }

    void scheduleAttributeChange(@NotNull VirtualFile file2, @VirtualFile.PropName @NotNull String property, Object current2, Object upToDate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("update file=" + file2 + ' ' + property + '=' + current2 + "->" + upToDate);
        }
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file2, property, current2, upToDate, true));
    }

    void addAllEventsFrom(@NotNull VfsEventGenerationHelper otherHelper) {
        this.myEvents.addAll(otherHelper.myEvents);
    }
}

